% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{splitDataByRegion}
\alias{splitDataByRegion}
\title{Split methylation data into regions based on the spacing of CpGs}
\usage{
splitDataByRegion(
  dat,
  gap = 1e+06,
  min.cpgs = 50,
  max.cpgs = 2000,
  verbose = TRUE
)
}
\arguments{
\item{dat}{a data frame with rows as individual CpGs appearing in all the
samples. The first 4 columns should contain the information of \code{Meth_Counts}
(methylated counts), \code{Total_Counts} (read depths), \code{Position} (Genomic
position for the CpG site) and \code{ID} (sample ID). The covariate information,
such as disease status or cell type composition, are listed in column 5 and
onwards.}

\item{gap}{positive integer defining the gap width
beyond which we consider that two regions are independent.
Odd and decimal values will be rounded to the next even numbers
(e.g. 8.2 and 8.7 become gaps of 8 and 10 respectively).
The default value is \code{1e+6} (1Mb).}

\item{min.cpgs}{positive integer defining the minimum number of
CpGs within a region for the algorithm to perform optimally.
The default value is 50.}

\item{max.cpgs}{positive integer defining the maximum number of
CpGs within a region for the algorithm to perform optimally.
The default value is 2000.}

\item{verbose}{logical indicates if the algorithm should provide progress
report information.
The default value is TRUE.}
}
\value{
A named \code{list} of \code{data.frame} containing the data of each
independent region.
}
\description{
This function splits the methylation data into regions
based on the spacing of CpGs.
}
\examples{
#------------------------------------------------------------#
data(RAdat)
RAdat.f <- na.omit(RAdat[RAdat$Total_Counts != 0, ])
results <- splitDataByRegion( dat=RAdat.f, gap = 1e6, min.cpgs = 5, 
verbose = FALSE)
}
\author{
Audrey Lemaçon
}
