% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plotBinCounts}
\alias{plotBinCounts}
\title{Visualize counts or enrichment for a particular region across bins, datasets, and read groups.}
\usage{
plotBinCounts(SNPhood.o, regions = 1, readGroups = NULL, datasets = NULL,
  readGroupColors = NULL, ylim = NULL, addGenotype = TRUE,
  plotGenotypeRatio = FALSE, addTitle = TRUE, colorPalette = "Set1",
  printPlot = TRUE, fileToPlot = NULL, maxWidthLabels = NULL,
  verbose = FALSE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{regions}{Numeric or Character or NULL. Default NULL. Regions that should be plotted, either specified as integer (such as 1, value must be
between 1 and the total number of regions as defined in the object) or their annotation (name must appear in the region names as obtained via the function \code{annotationRegions}). If set to NULL, all regions will be considered.}

\item{readGroups}{Character or NULL. Default NULL. Read groups that should be plotted, specified by their name as obtained by the function \code{annotationReadGroups}). If set to NULL, all read groups will be considered.}

\item{datasets}{Numeric or Character or NULL. Default NULL. Datasets that should be used for plotting, either specified as integer (such as 1, value must be
between 1 and the total number of datasets as defined in the object) or their annotation (name must appear in the dataset names as obtained via the function \code{annotationDatasets}). If set to NULL, all datasets will be considered.}

\item{readGroupColors}{Character or NULL. Default NULL. Colors of the read groups that appear in the plot.
If set to NULL, colors will be set automatically. The length of the vector must equal the \strong{total} number of read groups 
that are defined in the \code{SNPhood} object.}

\item{ylim}{Numeric(2). Default NULL. Range of the y-axis, as specified by a minimum and a maximum value. See ?ylim for details.}

\item{addGenotype}{Logical(1). Default TRUE. Should the genotype distribution for each read group at the original user position be displayed in the legend in addition?
See the Vignette for more details how this distribution is determined.}

\item{plotGenotypeRatio}{Logical(1). Default FALSE. Should the ratio of the genotypes be plotted instead of the count or enrichment values?
Only applicable if the number of read groups to be plotted is 2 and if one region is plotted. Setting this parameter to TRUE may result in ratios across bins that are interrupted due to
zero counts (and a resulting division by zero, which can therefore not be displayed). Also, ratios cannot be plotted if the genotype for the selected
regions could not be determined due to the lack of reads overlapping with the particular region (see the Vignette for details).}

\item{addTitle}{Logical(1). Default TRUE. Should the plot contain a title that summarizes the genomic region that is visualized?}

\item{colorPalette}{Character(1). Default "Set1". Name of the palette from the \code{RColorBrewer} package from the qualitative palettes
for the colors of the datasets that are plotted. 
Allowed palette names are "Accent", "Dark2", "Paired", "Pastel1", "Pastel2", "Set1", "Set2", and "Set3". Colors for the datasets are
then determined automatically from the given palette name (from left to right, depending on the number of datasets to be plotted).
The colors for the read groups within each datasets are based on the colors for the dataset, but with different saturation values.}

\item{printPlot}{Logical(1). Default TRUE. Should the plots be printed? Only relevant if \code{fileToPlot} is set to NULL; otherwise, the plots
are always printed to the output file.}

\item{fileToPlot}{Character(1) or \code{NULL}. Default \code{NULL}. 
Filename of the PDF file for the output plots.
If set to \code{NULL}, plots will be plotted to the currently active device.}

\item{maxWidthLabels}{Numeric(1). Default NULL. Maximum width of the legend labels in number of characters. 
If the width of the legend labels are longer, they are shortened. Set to NULL to not shorten labels.}

\item{verbose}{Logical(1). Default FALSE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
the generated \pkg{ggplot2} plot(s) as list for further processing. May contain multiple plots, depending on the function. The plot(s) can then be plotted individually or modified arbitrarily as the user wants. For example, if multiple plots are returned and the plots have been saved in a variable called plots.l, simply type plots.l[[1]] to view the first plot.
}
\description{
\code{plotBinCounts} visualizes counts or enrichment for a particular region across bins, datasets, and read groups. 
Many graphical parameters can be adjusted to suit the needs of the user, see below.
}
\examples{
data(SNPhood.o, package="SNPhood")

# Plot the first region, all parameters with their default values
plot = plotBinCounts(SNPhood.o)

# Plot the second region for the first dataset, using specific colors for the read groups.
plot = plotBinCounts(SNPhood.o, regions = 2, dataset = 1, readGroupColors = c("red","blue","gray"))

# Plot the first region for the first dataset and the genotype ratio. Save the plot in a variable
plot = plotBinCounts(SNPhood.o, regions = 1, readGroups = c("maternal", "paternal"), dataset = 1, plotGenotypeRatio = TRUE)

#' # Plot all regions for the first dataset and aggregate. Save the plot in a variable
plot = plotBinCounts(SNPhood.o, regions = NULL, readGroups = c("maternal", "paternal"), dataset = 1)

}

