% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emalgth1.R
\name{emalgth1}
\alias{emalgth1}
\title{Calculate the probability on condition that the sums more than 1.}
\usage{
emalgth1(X)
}
\arguments{
\item{X}{A matrix about X, the elements in X takes values on {0,1} and
satisfy the sums of each row more than 1.}
}
\value{
y1 The probability when sums more than 1.
}
\description{
Calculate the probability on condition that at least a CpG 
contributes to a short read.
}
\examples{
set.seed(123)
d <- matrix(0, nrow=200, ncol=50)
random_num <- sample(1:10, 200, replace=TRUE)
for(i in 1:nrow(d)){
    temp <- sample(1:50, random_num[i], replace=FALSE)
    d[i,temp] <- 1
}
result <- emalgth1(d)
head(result)
}
