% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation_plot.r
\encoding{UTF-8}
\name{model.evaluation.plot}
\alias{model.evaluation.plot}
\title{Model Evaluation Plot}
\usage{
model.evaluation.plot(..., fn.plot = NULL, 
colours=NULL, show.all=FALSE, verbose = 1)
}
\arguments{
\item{...}{one or more object of class \link{siamcat-class}, can be named}

\item{fn.plot}{string, filename for the pdf-plot}

\item{colours}{colour specification for the different \link{siamcat-class}-
objects, defaults to \code{NULL} which will cause the colours to be 
picked from the \code{'Set1'} palette}

\item{show.all}{boolean, Should the results from repeated cross-validation 
models be plotted? Defaults to \code{FALSE}, leading to a single line for 
the mean across cross-valdiation repeats}

\item{verbose}{control output: \code{0} for no output at all, \code{1}
for only information about progress and success, \code{2} for normal
level of information and \code{3} for full debug information,
defaults to \code{1}}
}
\value{
Does not return anything, but produces the model evaluation plot.
}
\description{
Produces plots for model evaluation.
}
\section{Binary classification problems}{

The first plot shows the Receiver Operating Characteristic (ROC)-curve, 
the other plot the Precision-recall (PR)-curve for the model. If 
\code{show.all == FALSE} (which is the default), a single line representing 
the mean across cross-validation repeats will be plotted, otherwise the 
individual cross-validation repeats will be included as 
lightly shaded lines.
}

\section{Regression problems}{

For regression problems, this function will produce a scatter plot between
the real and predicted values. If several \link{siamcat-class}-objects are
supplied, a single plot for each object will be produced.
}

\examples{
data(siamcat_example)

# simple working example
model.evaluation.plot(siamcat_example, fn.plot='./eval.pdf')

# plot several named SIAMCAT object
# although we use only one example object here
model.evaluation.plot('Example_1'=siamcat_example,
    'Example_2'=siamcat_example, colours=c('red', 'blue'),
    fn.plot='./eval.pdf')
    
# show indiviudal cross-validation repeats
model.evaluation.plot(siamcat_example, fn.plot='./eval.pdf', show.all=TRUE)
}
\keyword{SIAMCAT}
\keyword{model.evaluation.plot}
