% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{setaTransform}
\alias{setaTransform}
\title{Wrapper for Compositional Transforms with Optional Within-Lineage Resolutions
A convenience function that dispatches to one of the transforms:
CLR, ALR, ILR, percent, or logCPM. Note that the input \code{counts} matrix
should have rows as samples and columns as taxa. Optionally, you can supply
a taxonomy data frame to perform a within-lineage transform at a specified
resolution.}
\usage{
setaTransform(
  counts,
  method = c("CLR", "ALR", "ILR", "percent", "logCPM", "balance"),
  ref = NULL,
  taxTree = NULL,
  pseudocount = 1,
  size_factors = NULL,
  taxonomyDF = NULL,
  taxonomy_col = NULL,
  within_resolution = FALSE,
  balances = NULL,
  normalize_to_parent = FALSE
)
}
\arguments{
\item{counts}{A numeric matrix with rows as samples and columns as taxa.}

\item{method}{A character string specifying which transform to apply.
One of \code{"CLR"}, \code{"ALR"}, \code{"ILR"}, \code{"percent"},
\code{"logCPM"} or \code{"balance"}.}

\item{ref}{Reference taxon (only used if \code{method = "ALR"}). This can be
a taxon name or a column index.}

\item{taxTree}{Optional tree for ILR (not yet implemented).}

\item{pseudocount}{Numeric, used by CLR, ALR, ILR, and logCPM. Default is 1.}

\item{size_factors}{For logCPM scaling. If \code{NULL}, uses row sums.}

\item{taxonomyDF}{Optional data frame specifying higher-level groupings
for each taxon. Row names of \code{taxonomyDF} should match
\code{colnames(counts)}.}

\item{taxonomy_col}{The column of \code{taxonomyDF} indicating which lineage
each taxon belongs to. Only used if \code{within_resolution = TRUE}.}

\item{within_resolution}{Logical. If \code{TRUE}, applies the transform
within each lineage of taxa defined by \code{taxonomyDF[[taxonomy_col]]}
separately, then merges them back into the original matrix structure.
Default is \code{FALSE}. Ignored for `"balance"`.}

\item{balances}{For `"balance"`: a single balance list or a named list;}

\item{normalize_to_parent}{Logical, passed to [setaBalance()].}
}
\value{
A list with the following elements:
\describe{
    \item{transform_method}{The core transform, e.g. \"CLR\", \"ALR\", etc.}
    \item{within_resolution}{Logical indicating if a within-lineage transform
        was used.}
    \item{grouping_var}{The name of the column in \code{taxonomyDF} used for
        grouping (lineages) if \code{within_resolution = TRUE}, otherwise
        \code{NULL}.}
    \item{counts}{The resulting matrix after transformation, with the same
        dimensions as the input \code{counts}.}
}
}
\description{
Wrapper for Compositional Transforms with Optional Within-Lineage Resolutions
A convenience function that dispatches to one of the transforms:
CLR, ALR, ILR, percent, or logCPM. Note that the input \code{counts} matrix
should have rows as samples and columns as taxa. Optionally, you can supply
a taxonomy data frame to perform a within-lineage transform at a specified
resolution.
}
\examples{
mat <- matrix(c(1, 2, 4, 8, 3, 6, 9, 12),
              nrow = 2, byrow = TRUE)
colnames(mat) <- c("TaxonA1", "TaxonA2", "TaxonB1", "TaxonB2")

# Build a taxonomy data frame labeling lineages
df_lineage <- data.frame(
    Lineage = c("LineageA", "LineageA", "LineageB", "LineageB"),
    row.names = colnames(mat)
)

# Apply CLR transform to all columns together
out1 <- setaTransform(mat, method = "CLR")

# Apply CLR within each Lineage
out2 <- setaTransform(
    mat,
    method = "CLR",
    taxonomyDF = df_lineage,
    taxonomy_col = "Lineage",
    within_resolution = TRUE
)
}
