% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\docType{methods}
\name{sc3_prepare}
\alias{sc3_prepare}
\alias{sc3_prepare.SingleCellExperiment}
\alias{sc3_prepare,SingleCellExperiment-method}
\alias{sc3_prepare,SingleCellExperiment-method}
\alias{sc3_prepare}
\title{Prepare the \code{SingleCellExperiment} object for \code{SC3} clustering.}
\usage{
sc3_prepare.SingleCellExperiment(object, gene_filter, pct_dropout_min,
  pct_dropout_max, d_region_min, d_region_max, svm_num_cells, svm_train_inds,
  svm_max, n_cores, kmeans_nstart, kmeans_iter_max, rand_seed)

\S4method{sc3_prepare}{SingleCellExperiment}(object, gene_filter = TRUE,
  pct_dropout_min = 10, pct_dropout_max = 90, d_region_min = 0.04,
  d_region_max = 0.07, svm_num_cells = NULL, svm_train_inds = NULL,
  svm_max = 5000, n_cores = NULL, kmeans_nstart = NULL,
  kmeans_iter_max = 1e+09, rand_seed = 1)
}
\arguments{
\item{object}{an object of \code{SingleCellExperiment} class.}

\item{gene_filter}{a boolen variable which defines whether to perform gene 
filtering before SC3 clustering.}

\item{pct_dropout_min}{if \code{gene_filter = TRUE}, then genes with percent of dropouts smaller than 
\code{pct_dropout_min} are filtered out before clustering.}

\item{pct_dropout_max}{if \code{gene_filter = TRUE}, then genes with percent of dropouts larger than 
\code{pct_dropout_max} are filtered out before clustering.}

\item{d_region_min}{defines the minimum number of eigenvectors used for 
kmeans clustering as a fraction of the total number of cells. Default is \code{0.04}.
See \code{SC3} paper for more details.}

\item{d_region_max}{defines the maximum number of eigenvectors used for 
kmeans clustering as a fraction of the total number of cells. Default is \code{0.07}.
See \code{SC3} paper for more details.}

\item{svm_num_cells}{number of randomly selected training cells to be used 
for SVM prediction. The default is \code{NULL}.}

\item{svm_train_inds}{a numeric vector defining indeces of training cells 
that should be used for SVM training. The default is \code{NULL}.}

\item{svm_max}{define the maximum number of cells below which SVM is not run.}

\item{n_cores}{defines the number of cores to be used on the user's machine. If not set, `SC3` will use all but one cores of your machine.}

\item{kmeans_nstart}{nstart parameter passed to \code{\link[stats]{kmeans}} function. Default is 
\code{1000} for up to \code{2000} cells and \code{50} for more than \code{2000} cells.}

\item{kmeans_iter_max}{iter.max parameter passed to \code{\link[stats]{kmeans}} 
function. Default is \code{1e+09}.}

\item{rand_seed}{sets the seed of the random number generator. \code{SC3} is a stochastic
method, so setting the \code{rand_seed} to a fixed values can be used for reproducibility
purposes.}
}
\value{
an object of \code{SingleCellExperiment} class
}
\description{
This function prepares an object of \code{SingleCellExperiment} class for \code{SC3} clustering. It
creates and populates the following items of the \code{sc3} slot of the \code{metadata(object)}:
\itemize{
  \item \code{kmeans_iter_max} - the same as the \code{kmeans_iter_max} argument.
  \item \code{kmeans_nstart} - the same as the \code{kmeans_nstart} argument.
  \item \code{n_dim} - contains numbers of the number of eigenvectors to be used
  in \code{\link[stats]{kmeans}} clustering.
  \item \code{rand_seed} - the same as the \code{rand_seed} argument.
  \item \code{svm_train_inds} - if SVM is used this item contains indexes of the 
  training cells to be used for SC3 clustering and further SVM prediction.
  \item \code{svm_study_inds} - if SVM is used this item contains indexes of the
   cells to be predicted by SVM.
  \item \code{n_cores} - the same as the \code{n_cores} argument.
}
}
