% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.utilities.R
\docType{class}
\name{glyph-class}
\alias{glyph-class}
\title{An object to store glyph information}
\description{
An object to store glyph information
}
\details{
User can modify glyph objects to change the way how they are rendered. See the "glyphs.user" argument in \code{\link{renderSbgn}}.
}
\section{Slots}{

\describe{
\item{\code{compartment}}{A character string. The compartment this glyph belongs to.}

\item{\code{x,y,h,w}}{Numeric. The x,y location and hight, width of the glyph.}

\item{\code{id}}{A character string. The ID of the glyph (determined by the 'id' attribute in element 'glyph').}

\item{\code{label}}{A character string. label of the glyph. Extracted from the element 'label'.}

\item{\code{glyph.class}}{A character string. Class of the glyph.}

\item{\code{user.data}}{A numeric vector. The omics data mapped to this glyph.}

\item{\code{stroke.width,stroke.opacity,fill.opacity}}{Numeric. Controls glyph border width or opacity of node fill and border.}

\item{\code{fill.color,stroke.color}}{A character string. The fill color and stroke color of glyph.}

\item{\code{label_location}}{A character string. One of 'center' or 'top'. If set to 'center', the glyph label text will be displayed at the center of the glyph. If set to 'top', the label will be displayed at the top of the glyph.}

\item{\code{orientation}}{A character string. One of 'left','right','up','down'. This only applies to glyphs of classes 'terminal' and 'tag'. It will change the orientation of the node.}

\item{\code{parameters.list}}{A list. The parameters.list slot is a copy of the global.parameters.list. The global.parameters.list contains the '...' parameters passed into \code{\link{SBGNview}} which will be used by \code{\link{renderSbgn}}. By default this slot for all glyph objects in the output SBGNview object will be an empty list. You can add named elements to this slot to customize each individual glyph. For information about which parameters can be set in the parameters.list slot, see the arguments in \code{\link{renderSbgn}}. A customized list of glyph objects can be passed as input into SBGNview function using the ‘glyphs.user’ argument (see \code{\link{renderSbgn}} for more information).}

\item{\code{shape}}{A list. Parameters controlling how the node is rendered. Available elements can be accessed as follow:
glyph@shape$stroke.color\cr
        -Character (e.g. 'red'). The color of glyph border. \cr
glyph@shape$stroke.opacity\cr
        -Numeric (e.g. 0.8). The opacity of glyph border. Must be between 0 and 1.\cr
glyph@shape$stroke.width\cr
        -Numeric. The thickness of glyph border.\cr
glyph@shape$fill.opacity\cr
        -Numeric. The opacity of glyph fill. Must be between 0 and 1.\cr
glyph@shape$fill.color\cr
        -Numeric. The glyph fill color. Note that this will overwrite colors generated from omics data!\cr}

\item{\code{text}}{A list. Parameters controlling how node label is rendered. Available elements can be accessed as follow:
glyph@text$y.shift\cr
        -Numeric. Move glyph label vertically by this value.\cr
glyph@text$x.shift\cr
        -Numeric. Move glyph label horizontally by this value.\cr
glyph@text$color\cr
        -A character string. The color of glyph label.\cr
glyph@text$font.size\cr
        -A character string. The font size of glyph label.\cr}
}}

