% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotPPiRoc}
\alias{plotPPiRoc}
\title{Plot PPI ROC curve}
\usage{
plotPPiRoc(tpcaObj, computeAUC = FALSE)
}
\arguments{
\item{tpcaObj}{tpcaResult object}

\item{computeAUC}{logical parameter indicating
whether area under the ROC should be computed
and indicated in the lower right corner of the 
plot}
}
\value{
ggplot object of a receiver operating
curve (ROC)
}
\description{
Plot PPI ROC curve
}
\examples{
rocTab = data.frame(
    TPR = c(0, 0.1, 0.2, 0.4, 0.5, 0.7, 0.9, 1),
    FPR = c(0, 0.05, 0.1, 0.2, 0.5, 0.7, 0.9, 1)
)

tpcaTest <- new(
    "tpcaResult",
    PPiRocTable = rocTab)

plotPPiRoc(tpcaTest)

}
