% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcReadQualityBoxCalc.R,
%   R/rqcReadQualityBoxPlot.R
\name{rqcReadQualityBoxCalc}
\alias{rqcReadQualityBoxCalc}
\alias{rqcReadQualityBoxPlot}
\title{Per read mean quality box plot}
\usage{
rqcReadQualityBoxCalc(rqcResultSet)

rqcReadQualityBoxPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
Plot object from \code{\link{ggplot}} function.
}
\description{
This function creates crate a graphic charts with box plots describing per
read mean quality distribution for each input file
}
\section{Functions}{
\itemize{
\item \code{rqcReadQualityBoxCalc}: calculates necessary statistics
}}

\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcReadQualityBoxPlot(rqcResultSet)

}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
