% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcReadFrquencyCalc.R, R/rqcReadFrquencyPlot.R
\name{rqcReadFrequencyCalc}
\alias{rqcReadFrequencyCalc}
\alias{rqcReadFrequencyPlot}
\title{Read frequency plot}
\usage{
rqcReadFrequencyCalc(rqcResultSet)

rqcReadFrequencyPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
Plot object from \code{\link{ggplot}} function.
}
\description{
This function creates a bar graph of read frequency (in percentage).
}
\section{Functions}{
\itemize{
\item \code{rqcReadFrequencyCalc}: calculates necessary statistics
}}

\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcReadFrequencyPlot(rqcResultSet)

}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
