% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcFileHeatmap.R
\name{rqcFileHeatmap}
\alias{rqcFileHeatmap}
\title{Heatmap of distance matrix of top over-represented reads}
\usage{
rqcFileHeatmap(
  rqcResultSet,
  dist.method = "euclidean",
  hclust.method = "ward.D"
)
}
\arguments{
\item{rqcResultSet}{\code{RqcResultSet} object created by \code{\link{rqc}}
and \code{\link{rqcQA}} functions.}

\item{dist.method}{the distance measure to be used by \code{\link{dist}} function.}

\item{hclust.method}{the agglomeration method to be used by \code{\link{hclust}} function.}
}
\value{
Plot object from \code{\link{ggplot}} function.
}
\description{
This function plots a heatmap of distance matrix of top over-represented
reads. This function does not work with list of RqcResultSet objects, only
with one RqcResultSet object.
}
\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcFileHeatmap(rqcResultSet[[1]])

}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
