% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcCycleQualityBoxCalc.R,
%   R/rqcCycleQualityBoxPlot.R
\name{rqcCycleQualityBoxCalc}
\alias{rqcCycleQualityBoxCalc}
\alias{rqcCycleQualityBoxPlot}
\title{Per cycle quality box plot}
\usage{
rqcCycleQualityBoxCalc(rqcResultSet)

rqcCycleQualityBoxPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
Plot object from \code{\link{ggplot}} function.
}
\description{
Plots per cycle quality box plot.
}
\section{Functions}{
\itemize{
\item \code{rqcCycleQualityBoxCalc}: calculates necessary statistics
}}

\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcCycleQualityBoxPlot(rqcResultSet)

}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
