% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcCycleAverageQualityCalc.R,
%   R/rqcCycleAverageQualityPlot.R
\name{rqcCycleAverageQualityCalc}
\alias{rqcCycleAverageQualityCalc}
\alias{rqcCycleAverageQualityPlot}
\title{Per cycle average quality by files}
\usage{
rqcCycleAverageQualityCalc(rqcResultSet)

rqcCycleAverageQualityPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
ggplot2 object
}
\description{
This function plots line graph of per cycle average quality.
}
\section{Functions}{
\itemize{
\item \code{rqcCycleAverageQualityCalc}: calculates necessary statistics
}}

\examples{
checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcCycleAverageQualityPlot(rqcResultSet)
}
\seealso{
\code{\link{rqcGroupCycleAverageQualityPlot}} plots cycle-specific quality by groups
}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
