% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSize.R
\name{sample_size}
\alias{sample_size}
\title{sample_size}
\usage{
sample_size(
  power = 0.8,
  m = 20000,
  m1 = 200,
  f = 0.1,
  k = 1,
  w = 1,
  rho = 2,
  lambda0 = 5,
  phi0 = 1,
  showMessage = FALSE,
  storeProcess = FALSE
)
}
\arguments{
\item{power}{Power to detect prognostic genes.}

\item{m}{Total number of genes for testing.}

\item{m1}{Expected number of prognostic genes.}

\item{f}{FDR level}

\item{k}{Ratio of sample size between two groups (Treatment/Control).}

\item{w}{Ratio of normalization factors between two groups.}

\item{rho}{minimum fold changes for prognostic genes between two groups (Treatment/Control).}

\item{lambda0}{Average read counts for prognostic genes.}

\item{phi0}{Dispersion for prognostic genes.}

\item{showMessage}{Logical. Display the message in the estimation process.}

\item{storeProcess}{Logical. Store the power and n in sample size or power estimation process.}
}
\value{
Estimate sample size or a list including parameters and sample size in the process.
}
\description{
A function to estitamete the sample size for differential expression analysis of RNA-seq data.
}
\details{
A function to estitamete the sample size for differential expression analysis of RNA-seq data.
}
\examples{
power<-0.8;rho<-2;lambda0<-5;phi0<-0.5;f<-0.01
sample_size(power=power, f=f,rho=rho, lambda0=lambda0, phi0=phi0)
}
