% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{est_count_dispersion}
\alias{est_count_dispersion}
\title{est_count_dispersion}
\usage{
est_count_dispersion(
  counts,
  group = rep(1, NCOL(counts)),
  subSampleNum = 20,
  minAveCount = 1,
  convertId = FALSE,
  dataset = "hsapiens_gene_ensembl",
  filters = "hgnc_symbol"
)
}
\arguments{
\item{counts}{numeric matrix of read counts.}

\item{group}{vector or factor giving the experimental group/condition for each sample/library.}

\item{subSampleNum}{number of samples used to estitamete distribution.}

\item{minAveCount}{Only genes with avarage read counts above this value are used in the estimation of distribution.}

\item{convertId}{logical, whether to convert th gene Id into entrez gene Id. If set as True, then dataset and filters parameter should also be set.}

\item{dataset}{Dataset you want to use.  To see the different datasets available within a biomaRt you can e.g. do:  mart = useMart('ensembl'), followed by listDatasets(mart).}

\item{filters}{Filters (one or more) that should be used in the query.  A possible list of filters can be retrieved using the function listFilters.}
}
\value{
A DEGlist from edgeR package.
}
\description{
A function to estitamete the gene read count and dispersion distribution of RNA-seq data.
}
\details{
A function to estitamete the gene read count and dispersion distribution of RNA-seq data.
}
\examples{
counts<-matrix(sample(1:1000,6000,replace=TRUE),ncol=6)
est_count_dispersion(counts=counts,group=rep(0,6))
}
