% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlPlots.R
\name{rnb.plot.snp.boxplot}
\alias{rnb.plot.snp.boxplot}
\title{rnb.plot.snp.boxplot}
\usage{
rnb.plot.snp.boxplot(dataset, writeToFile = FALSE, ...)
}
\arguments{
\item{dataset}{Dataset as an object of type inheriting \code{\linkS4class{RnBeadSet}}, or a matrix of
methylation beta values.}

\item{writeToFile}{Flag specifying whether the output should be saved as \code{\linkS4class{ReportPlot}}.}

\item{...}{Additional named arguments passed to \code{\link{createReportPlot}}.}
}
\value{
If \code{writeToFile} is \code{TRUE}: plot as an object of type \code{\linkS4class{ReportPlot}}. Otherwise:
        plot as an object of type \code{\link{ggplot}}.
}
\description{
Box plots of beta-values from the genotyping probes
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.plot.snp.boxplot(rnb.set.example)
}
}
\author{
Pavlo Lutsik
}
