% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlPlots.R
\name{rnb.plot.sentrix.distribution}
\alias{rnb.plot.sentrix.distribution}
\title{rnb.plot.sentrix.distribution}
\usage{
rnb.plot.sentrix.distribution(rnb.set, sentrix.id)
}
\arguments{
\item{rnb.set}{HumanMethylation450K dataset as an object of type \code{\linkS4class{RnBeadSet}}.}

\item{sentrix.id}{Slide number (Sentrix ID) as an \code{integer} or \code{character} singleton.}
}
\value{
Generated point-and-whisker plot (an instance of \code{\link{ggplot}}) of mean methylations for the samples
        on the specified slide, or \code{FALSE} if the dataset is non-empty but does not contain samples on the
        given slide. If the provided dataset does not contain valid Sentrix ID and position information (or is an
        empty dataset), this method returns \code{NULL}.
}
\description{
Creates a point-and-whisker plots showing beta value distributions at Sentrix positions for the given slide.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
sid<-as.character(pheno(rnb.set.example)[["Sentrix_ID"]][1])
rnb.plot.sentrix.distribution(rnb.set.example,sid)
}
}
\author{
Yassen Assenov
}
