% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Report-methods.R
\name{rnb.initialize.reports}
\alias{rnb.initialize.reports}
\title{rnb.initialize.reports}
\usage{
rnb.initialize.reports(dir.reports, dir.configuration = "configuration")
}
\arguments{
\item{dir.reports}{Directory to host report files. This must be a \code{character} of length one that specifies
a non-existent path, as this methods attempts to create it.}

\item{dir.configuration}{Subdirectory to host configuration files shared by the reports. This must be a
\code{character} of length one that gives location as a path relative to \code{dir.reports}.
Also, strong restrictions apply to the path name. See the description of the
\code{\link{createReport}} function for more details. This method creates the directory and
copies configuration files that define cascading style sheet (CSS) definitions and
Javascript functions used by the HTML reports.}
}
\value{
\code{TRUE} if the report directory was successfully created and the configuration files were copied to the
        specified location; \code{FALSE} otherwise.
}
\description{
Creates a new directory to host HTML reports and copies the shared configuration files.
}
\examples{
\donttest{
dir.reports <- "~/infinium_studies/cancer_study/reports"
if (!rnb.initialize.reports(dir.reports)) {
    cat("ERROR: Could not initialize configuration in ", dir.reports, "\n", sep = "")
}
}

}
\seealso{
\code{\link{createReport}} for initializing an HTML report
}
\author{
Yassen Assenov
}
