% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rnb.get.reliability.matrix}
\alias{rnb.get.reliability.matrix}
\title{rnb.get.reliability.matrix}
\usage{
rnb.get.reliability.matrix(rnb.set, row.names = FALSE)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}

\item{row.names}{Flag indicating of row names are to be generated in the result.}
}
\value{
\code{logical} matrix in which every row corresponds to a CpG site or probe and every column - to a patient.
        If the dataset does not contain coverage or detection p-value information, the returned value is \code{NULL}.
}
\description{
Gets a matrix of reliability indications for every measurement in the given dataset.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.options(identifiers.column = "Sample_ID")
str(rnb.get.reliability.matrix(rnb.set.example))
}
}
\author{
Yassen Assenov
}
