% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{rnb.get.annotation}
\alias{rnb.get.annotation}
\title{rnb.get.annotation}
\usage{
rnb.get.annotation(type = "CpG", assembly = "hg19")
}
\arguments{
\item{type}{Name of annotation.}

\item{assembly}{Genome assembly of interest. See \code{\link{rnb.get.assemblies}} for the list of supported genomes.}
}
\value{
Probe, site or region annotation table. If the specified type refers to control probes, the returned value is
        a \code{data.frame} listing all respective control probes. Otherwise, this function returns an object of type
        \code{\link{GRangesList}} - a list of consistent \code{\link{GRanges}} objects, one per chromosome.
}
\description{
Extracts the requested annotation for the given genome.
}
\details{
When the returned value is of type \code{GRangesList}, it defines the genomic positions of the requested sites,
probes or regions. Identifiers, if present, can be obtained using the \code{names} method. Strand information is also
included when applicable. Any additional annotation is stored as metadata in the respective \code{GRanges} objects.
}
\examples{
\donttest{
rnb.get.annotation("promoters")
}
}
\seealso{
\code{\link{rnb.set.annotation}} for adding annotation;
  \code{\link{rnb.region.types}} for all loaded region types in a genome assembly
}
\author{
Fabian Mueller
}
