% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{rnb.execute.snp.removal}
\alias{rnb.execute.snp.removal}
\title{rnb.execute.snp.removal}
\usage{
rnb.execute.snp.removal(rnb.set, snp = rnb.getOption("filtering.snp"))
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}

\item{snp}{Criterion for the removal of sites or probes based on overlap with SNPs. Possible values are
\code{"no"}, \code{"3"}, \code{"5"}, \code{"any"} or \code{"yes"}. See the documentation of
\code{\link{rnb.options}} for a detailed explanation of the procedures these values encode.}
}
\value{
\code{list} of four elements:
        \describe{
          \item{\code{"dataset.before"}}{Copy of \code{rnb.set}.}
          \item{\code{"dataset"}}{The (possibly) modified dataset object after removing probes that overlap
               with SNPs.}
          \item{\code{"filtered"}}{\code{integer} vector storing the indices (in beta matrix of the unfiltered
               dataset) of all removed sites or probes.}
          \item{\code{"snp"}}{The value of the \code{snp} parameter.}
        }
}
\description{
Removes all probes overlapping with single nucleotide polymorphisms (SNPs) from the given dataset.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.set.filtered <- rnb.execute.snp.removal(rnb.set.example, "any")$dataset
identical(meth(rnb.set.example), meth(rnb.set.filtered)) # FALSE
}
}
\author{
Yassen Assenov
}
