% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.R
\name{rnb.execute.dreduction}
\alias{rnb.execute.dreduction}
\title{rnb.execute.dreduction}
\usage{
rnb.execute.dreduction(rnb.set, target = "sites")
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}. This dataset
must contain at least four samples.}

\item{target}{\code{character} singleton specifying the level of DNA methylation infromation. If this is
   \code{"sites"}, the DNA methylation information for the individual sites or probes is analyzed.
   Otherwise, this should be one of the supported region types, as returned by
\code{\link{rnb.region.types}}.}
}
\value{
Results of the dimension reduction in the form of a list with the following elements:
        \describe{
          \item{\code{pca}}{Results of the PCA as returned by the function \code{\link{prcomp}}.}
          \item{\code{mds}}{List of two elements - \code{"manhattan"} and \code{"euclidean"}, each of which is a
               two-column \code{matrix} storing the coordinates of the samples in a two-dimensional space. The
               matrices are computed using the function \code{\link{isoMDS}}.}
        }
}
\description{
Performs principal component analysis (PCA) and multi-dimensional scaling (MDS) of the samples in the given
methylation dataset.
}
\details{
Row names in the returned matrices are sample identifiers, determined based on the package option
\code{"identifiers.column"}. See \emph{\link[=rnb.options]{RnBeads Options}} for more information on this option.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
regs <- c("sites", summarized.regions(rnb.set.example))
dreduction <- function(x) rnb.execute.dreduction(rnb.set.example, x)
pcoordinates <- lapply(regs, dreduction)
names(pcoordinates) <- regs
str(pcoordinates)
}
}
\seealso{
\code{\link{rnb.run.exploratory}} for running the whole exploratory analysis module
}
\author{
Yassen Assenov
}
