% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellTypeAdjustment.R
\name{rnb.execute.ct.estimation}
\alias{rnb.execute.ct.estimation}
\title{rnb.execute.ct.estimation}
\usage{
rnb.execute.ct.estimation(
  rnb.set,
  cell.type.column = NA,
  test.max.markers = NA,
  top.markers = 500,
  method = "houseman1",
  verbose = TRUE
)
}
\arguments{
\item{rnb.set}{object of class \code{\linkS4class{RnBSet}}}

\item{cell.type.column}{integer index or character identifier of a column in sample annotation table of \code{rnb.set}
which gives the mapping of samples to reference cell types}

\item{test.max.markers}{Maximal amount of CpG positions to use for marker selection. If this option is set to
   \code{NA} or \code{NULL}, all sites are considered. Please take into account the extended
computation time in such a case.}

\item{top.markers}{the number of markers to select}

\item{method}{algorithm used for estmation of the cell type contributions}

\item{verbose}{flag specifying whether diagnostic output should be written to the console 
or to the RnBeads logger in case the latter is initialized}
}
\value{
object of class \code{CellTypeInferenceResult}
}
\description{
Perform the estimation of the cell type contributions in each analyzed sample.
}
\details{
The only supported method is the one from Houseman et al BMC Bioinformatics 2012
}
\author{
Pavlo Lutsik
}
