% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Report-methods.R
\name{rnb.add.paragraph}
\alias{rnb.add.paragraph}
\title{rnb.add.paragraph}
\usage{
rnb.add.paragraph(report, txt, paragraph.class = NULL)
}
\arguments{
\item{report}{Report to write the text to.}

\item{txt}{\code{character} vector (or array) storing the text to be written. The elements of this vector
are concatenated without a separator.}

\item{paragraph.class}{CSS class definition of the paragraph. This must be either \code{NULL} (default) or one of:
\describe{
  \item{\code{"centered"}}{This paragraph gives a formula or a short statement. Text is
       horizontally centered.}
  \item{\code{"note"}}{This paragraph describes a note. Text is italic.}
  \item{\code{"task"}}{This paragraph describes a task. Text is bold and bright red.}
}}
}
\value{
The modified report, invisibly.
}
\description{
Generates HTML code for a new paragraph in the specified report.
}
\examples{
\donttest{
report <- createReport("example.html", "Example", init.configuration = TRUE)
txt <- "A pessimist is a person who has had to listen to too many optimists."
txt <- c(txt, " <i>Don Marquis</i>")
rnb.add.paragraph(report, txt)
}
}
\seealso{
\code{\linkS4class{Report}} for other functions adding contents to an HTML report
}
\author{
Yassen Assenov
}
