% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterArchitecture.R
\docType{class}
\name{ClusterArchitecture-class}
\alias{ClusterArchitecture-class}
\title{ClusterArchitecture Class}
\description{
A virtual class for storing specifications of architectures for different compute clusters. It is designed to
let other classes inherit from it
}
\details{
For a concrete child class for a sun grid architecture specification see \code{\linkS4class{ClusterArchitectureSGE}}
If you want to implement your own child class be sure to at least implement the following functions:
\code{\link{getSubCmdTokens,ClusterArchitecture-method}}.
}
\section{Slots}{

\describe{
  \item{\code{name}}{A name or identifier}
  \item{\code{executables}}{A NAMED character vector of executables that can be used by the cluster. For instance, the \code{R} executable is important} 
  \item{\code{getSubCmdTokens.optional.args}}{character vector containing the valid optional arguments to the \code{\link{getSubCmdTokens,ClusterArchitecture-method}} function.}
}
}

\section{Methods}{

\describe{
  \item{\code{\link{getSubCmdTokens,ClusterArchitecture-method}}}{Returns a vector of command line tokens corresponding to submitting
  a job with the given command to the cluster}
  \item{\code{\link{getSubCmdStr,ClusterArchitecture-method}}}{Returns a string for the of command line corresponding to submitting
  a job with the given command to the cluster}
  \item{\code{\link{setExecutable,ClusterArchitecture,character,character-method}}}{Tells the cluster architecture about an executable that can be submitted as job}
  \item{\code{\link{getExecutable,ClusterArchitecture,character-method}}}{Gets the location of an executable associated with a name}
}
}

\author{
Fabian Mueller
}
