% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riboSeqFromBAM.R
\name{riboSeqFromBAM}
\alias{riboSeqFromBAM}
\title{Starting from a BAM file path: quality plots, shift ribosome position,
coverage on multiple transcript features and on codons.}
\usage{
riboSeqFromBAM(listeInputBamFile, paramScanBAM, genomeName, txdb,
  percBestExpressed, flankSize, offsetStartEnd, listShiftValue)
}
\arguments{
\item{listeInputBamFile}{A character path or a vector of paths to the
ribo-seq BAM file(s). If multiple BAM files are provided, they should come
from the same genome alignment.}

\item{paramScanBAM}{NULL or ScanBamParam object specifying what fields and
which records are imported. Default value is NULL.}

\item{genomeName}{a character object containing the name of the genome used
for the alignment BAM file. The name should be one of the UCSC ensGene
list: ucscGenomes()[ , "db"]. Ex. "hg19" or "mm10". This parameter is used
to build the TxDb object.}

\item{txdb}{a TxDb object containing the annotations info to comfront with
the alignment files. Either genomeName or txdb parameters should be
provided.}

\item{percBestExpressed}{numeric [between 0 and 1]. The percentage of best
expressed CDSs on which to plot the coverage around the TSS. Necessary if
the shiftValue parameter must be estimated. Default value 0.03 (3\%).}

\item{flankSize}{an integer. How many bp left and right of the TSS should the
coverage be performed?}

\item{offsetStartEnd}{a character object. Either "start" (the default) or "end"
for read start or read end to define the offset.}

\item{listShiftValue}{a vector of integer. It should have the same length as
the inputBamFile vector. The numeric value for shifting ranges of reads on
genomic features when computing coverage. Set this parameter to 0 if no
shift should be performed. If this parameter is missing, the shiftValue is
computed based on the maximum peak of read start coverage around the TSS. A
plot is produced to illustrate this estimation.}
}
\value{
A list of list for each BAM file in the inputBamFile list. For each
  BAM file 2 objects are returned: one data.frame with info on the genomic
  features and the corresponding coverage column, and one list of per ORF
  codon coverage.
}
\description{
Starting from a BAM file path: quality plots, shift ribosome position,
coverage on multiple transcript features and on codons.
}
\examples{
#the txdb object can be given as parameter or not.
#If it is not specified, a txdb object is build from UCSC.
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene

#in this example only one BAM file is treated.
#However, multiple BAM files can be analyzed together.
myFile <- system.file("extdata", "ctrl_sample.bam", package="RiboProfiling")
listeInputBam <- c(myFile)

#when running this function it is important that chromosome names
#in UCSC and your BAM correspond: the "chr" particle
covData <- riboSeqFromBAM(listeInputBam, txdb=txdb, listShiftValue=c(-14))
}

