% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readStartCov.R
\name{readStartCov}
\alias{readStartCov}
\title{Read start coverage around the TSS on the predifined CDSs}
\usage{
readStartCov(
  alnGRanges,
  oneBinRanges,
  matchSize = "all",
  fixedInterval,
  renameChr,
  charPerc = "perc"
)
}
\arguments{
\item{alnGRanges}{A GRanges object containing the alignment information.
In order to improve the performance transform the GAlignments BAM object
into a GRanges object containing cigar match size as metadata.}

\item{oneBinRanges}{A GRanges object.
Transform the gene GRangesList into one big GRanges object.
Add the info on the cds_id.}

\item{matchSize}{either "all" or a vector of read match sizes.
If matchSize <- "all", then all the reads are used to compute the coverage.
If the matchSize is a vector of read match sizes,
the summarized coverage is reported per match size and for the sum up.}

\item{fixedInterval}{a numeric vector with the extremities of the interval.
Ex. fixedInterval <- c(-20,20) or fixedInterval <- c(0,40) ...}

\item{renameChr}{a character object.
It contains the name to be given to the new summarized coverage interval.
Ex. renameChr <- "aroundTSS" the summarized region around the TSS.}

\item{charPerc}{a character object. Either "perc" (the default) or "sum"
for percentage of counts per position or the sum of counts per position.}
}
\value{
a list of GRanges objects (for each matchSize chosen).
It contains the summarized coverage for the specified read match sizes.
}
\description{
Read start coverage around the TSS on the predifined CDSs
}
\examples{
#read the BAM into a GAlignments object using
#GenomicAlignments::readGAlignments
#the GAlignments object should be similar to ctrlGAlignments
data(ctrlGAlignments)
aln <- ctrlGAlignments

#transform the GAlignments object into a GRanges object (faster processing)
alnGRanges <- readsToStartOrEnd(aln, what="start")

#make a txdb object containing the annotations for the specified species.
#In this case hg19.
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene
#Please make sure that seqnames of txdb correspond to
#the seqnames of the alignment files ("chr" particle)
#if not rename the txdb seqlevels
#seqlevels(txdb) <- sub("chr", "", seqlevels(txdb))

#get the flanking region around the promoter of the best expressed CDSs
oneBinRanges <- aroundPromoter(txdb, alnGRanges, percBestExpressed=0.01)

#the coverage in the TSS flanking region for the summarized read match sizes
listPromoterCov <- readStartCov(
     alnGRanges,
     oneBinRanges,
     matchSize="all",
     fixedInterval=c(-20, 20),
     renameChr="aroundTSS",
     charPerc="perc"
)
}
