% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countsPlot.R
\name{countsPlot}
\alias{countsPlot}
\title{Graphs of sample read counts (quality assesment)}
\usage{
countsPlot(listCounts, ixCounts, log2Bool)
}
\arguments{
\item{listCounts}{a list of data.frame objects.
It contains the counts on the genomic features.
Each data.frame in the list should have the same number of columns.}

\item{ixCounts}{a numeric (a vector of integers).
It contains the index of the columns containing counts in the dataFrame.}

\item{log2Bool}{a numeric, either 0 or 1.
0 (default) for no log2 transformation and 1 for log2 transformation.}
}
\value{
A list of pairs and boxplots between the counts data in each data.frame.
}
\description{
Graphs of sample read counts (quality assesment)
}
\examples{
#read the BAM file into a GAlignments object using
#GenomicAlignments::readGAlignments
#the GAlignments object should be similar to ctrlGAlignments
data(ctrlGAlignments)
aln <- ctrlGAlignments

#transform the GAlignments object into a GRanges object (faster processing)
alnGRanges <- readsToStartOrEnd(aln, what="start")

#make a txdb object containing the annotations for the specified species.
#In this case hg19.
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene
#Please make sure that seqnames of txdb correspond to
#the seqnames of the alignment files ("chr" particle)
#if not rename the txdb seqlevels
#seqlevels(txdb, sub("chr", "", seqlevels(txdb))
#get the flanking region around the promoter of the best expressed CDSs

#get all CDSs by transcript
cds <- GenomicFeatures::cdsBy(txdb,by="tx",use.names=TRUE)

#get all exons by transcript
exonGRanges <- GenomicFeatures::exonsBy(txdb,by="tx",use.names=TRUE)

#get the per transcript relative position of start and end codons
cdsPosTransc <- orfRelativePos(cds, exonGRanges)

#compute the counts on the different features after applying
#the specified shift value on the read start along the transcript
countsData <-
   countShiftReads(
         exonGRanges[names(cdsPosTransc)],
         cdsPosTransc,
         alnGRanges,
         -14
     )

#now make the plots
listCountsPlots <- countsPlot(
   list(countsData[[1]]),
   grep("_counts$", colnames(countsData[[1]])),
   1
)
listCountsPlots
}
