% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aroundPromoter.R
\name{aroundPromoter}
\alias{aroundPromoter}
\title{Returns the flank size around the TSS for the x \% CDSs}
\usage{
aroundPromoter(txdb, alnGRanges, percBestExpressed, flankSize)
}
\arguments{
\item{txdb}{a TxDb object containing the annotations info to intersect with
the alignment files.}

\item{alnGRanges}{A GRanges object containing the alignment information. In
order to improve the performance of this function the GAlignments BAM
object should be transformed into a GRanges object containing the cigar
match size information as metadata.}

\item{percBestExpressed}{a numeric [between 0 and 1]. The percentage of the
best expressed CDSs on which to plot the coverage around the TSS. Necessary
if the shiftValue parameter must be estimated. Default value 0.03 (3\%).}

\item{flankSize}{a numeric positive integer. How many bp left and right of
the TSS should the coverage be performed? Ex. flankSize <- 20}
}
\value{
A GRanges object containing the 1 bp ranges for the selected CDSs in
  the TSS defined flanking region.
}
\description{
Returns the flank size around the TSS for the x \% CDSs
}
\examples{
#read the BAM into a GAlignments object using
#GenomicAlignments::readGAlignments
#the GAlignments object should be similar to ctrlGAlignments
data(ctrlGAlignments)
aln <- ctrlGAlignments
#transform the GAlignments object into a GRanges object (faster processing)
alnGRanges <- readsToStartOrEnd(aln, what="start")
#make a txdb object containing the annotations for the specified species.
#In this case hg19.
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene
#Please make sure that seqnames of txdb correspond to
#the seqnames of the alignment files ("chr" particle)
#if not rename the txdb seqlevels
#seqlevels(txdb) <- sub("chr", "", seqlevels(txdb))
#get the flanking region around the promoter of the best expressed CDSs
oneBinRanges <- aroundPromoter(txdb, alnGRanges)
}
