% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPermResults.R
\name{plotPermResults}
\alias{plotPermResults}
\title{Plot permutation test results}
\usage{
plotPermResults(permTestTx_results = NULL, breaks = 15, alpha = 0.05,
test_type = "one-sided", binwidth = NULL)
}
\arguments{
\item{permTestTx_results}{A \code{permTestTx.results} list object, which can be generated by the \code{permTestTx} function.}

\item{breaks}{Histogram breaks. Default is 15.}

\item{alpha}{Significance level.}

\item{test_type}{The type of the test. This argument only receives either two options "one-sided" or "two-sided". Default is "one-sided".}

\item{binwidth}{Histogram binwidth.}
}
\value{
A plot object.
}
\description{
Show a graphical representation of permutation test.
}
\examples{
file <- system.file(package="RgnTX", "extdata", "permTestTx_results.rds")
permTestTx_results <- readRDS(file)
p_a <- plotPermResults(permTestTx_results, binwidth = 1)
p_a
}
\seealso{
\code{\link{permTestTx}}
}
