% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-FactorisedExperiment.R,
%   R/methods-ModularExperiment.R
\name{runEnrich}
\alias{runEnrich}
\alias{runEnrich,FactorisedExperiment-method}
\alias{runEnrich,ModularExperiment-method}
\title{Functional enrichment analyses for dimensionally-reduced data}
\usage{
\S4method{runEnrich}{FactorisedExperiment}(
  object,
  method = "gsea",
  feature_id_col = "rownames",
  center_loadings = FALSE,
  abs_loadings = FALSE,
  loading_threshold = 0.5,
  proportional_threshold = 0.01,
  as_dataframe = FALSE,
  ...
)

\S4method{runEnrich}{ModularExperiment}(
  object,
  method = "overrepresentation",
  feature_id_col = "rownames",
  as_dataframe = FALSE,
  ...
)
}
\arguments{
\item{object}{\link[ReducedExperiment]{FactorisedExperiment}  or
\link[ReducedExperiment]{ModularExperiment} object.}

\item{method}{The method to use for identifying enriched pathways. One of
"overrepresentation" or "gsea". The "overrepresentation" method calls
\link[clusterProfiler]{enricher} whereas the "gsea" method calls
\link[clusterProfiler]{GSEA}. Note that "gsea" is not available for modules.}

\item{feature_id_col}{The column in \code{rowData(object)} that will be used as a
feature ID. Setting this to \code{"rownames"} (default) instead uses
\code{rownames(object)}.}

\item{center_loadings}{If \code{TRUE}, loadings will be centered
column-wise to have a mean of 0.}

\item{abs_loadings}{If \code{TRUE}, the absolute values of the
loadings will be used for enrichment analysis. If \code{FALSE}, the signed
loadings will be used for GSEA enrichment. Note that, regardless of the
value of this term, the process used to select genes for overrepresentation
analysis will be based on absolute loadings.}

\item{loading_threshold}{See
\link[ReducedExperiment]{getAlignedFeatures}. Only relevant for
overrepresentation analysis.}

\item{proportional_threshold}{See
\link[ReducedExperiment]{getAlignedFeatures}. Only relevant for
overrepresentation analysis.}

\item{as_dataframe}{If \code{TRUE}, the results will be returned as a data.frame.
Otherwise, the results will be returned as a list of objects created by
either \link[clusterProfiler]{enricher}, in the case of overrepresentation
analysis, or \link[clusterProfiler]{GSEA}, in the case of GSEA.}

\item{...}{Additional arguments to be passed to
\link[clusterProfiler]{GSEA} (if \code{method == "gsea"}) or
\link[clusterProfiler]{enricher} (if \code{method == "overrepresentation"}).}
}
\value{
If \code{as_dataframe} is \code{TRUE}, the results will be returned as a
data.frame. Otherwise, the results will be returned as a list of objects
created by either \link[clusterProfiler]{enricher}, in the case of
overrepresentation analysis, or \link[clusterProfiler]{GSEA}, in the case of
GSEA.
}
\description{
Method for applying pathway enrichment analysis to components identified
through dimensionality reduction (e.g., factors or modules).
Enrichment analyses are applied to each component
separately.
}
\details{
When running module analysis, the overrepresentation method identifies
pathways that are overrepresented in each module.

For factor analysis, the overrepresentation method first identifies the genes
most highly aligned with each factor
(using \link[ReducedExperiment]{getAlignedFeatures}), then uses
the resulting gene lists to perform overrepresentation analysis. The GSEA
method instead uses the entire set of factor loadings, and identifies
pathways that are overrepresented in the tails of this distribution.
}
\examples{
set.seed(2)
airway <- ReducedExperiment:::.getAirwayData(n_features = 2000)
airway_fe <- estimateFactors(
    airway,
    nc = 2,
    use_stability = FALSE,
    method = "imax"
)

# Get pathways (e.g., by using ReducedExperiment::getMsigdbT2G())
t2g <- read.csv(system.file(
    "extdata",
    "msigdb_t2g_filtered.csv",
    package = "ReducedExperiment"
))

# Run overrepresentation analysis
overrep_res <- runEnrich(
    airway_fe,
    method = "overrepresentation",
    feature_id_col = "rownames",
    as_dataframe = TRUE,
    p_cutoff = 0.1,
    TERM2GENE = t2g,
    universe = rownames(airway_fe)
)

head(overrep_res)

}
\seealso{
\code{\link[=getMsigdbT2G]{getMsigdbT2G()}}
}
\author{
Jack Gisby
}
