% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedRelaxMethods.R
\docType{methods}
\name{relax,RedPort-method}
\alias{relax,RedPort-method}
\alias{relax}
\title{Relax}
\usage{
\S4method{relax}{RedPort}(
  obj,
  p1 = 100,
  p2 = 100,
  p3 = 100,
  p4 = 100,
  p5 = 100,
  p6 = 10,
  p7 = 10,
  p8 = 100,
  p9 = 10
)
}
\arguments{
\item{obj}{A \code{RedPort}-class object.}

\item{p1}{Edge target length (unit in points; >= 1 ) <numeric>.}

\item{p2}{Edge stiffness (arbitrary unit; >= 0 ) <numeric>.}

\item{p3}{Node repulsion factor (arbitrary unit; >= 0 ) <numeric>.}

\item{p4}{Node perimeter effect (unit in points; >= 0 ) <numeric>.}

\item{p5}{Node speed limit (arbitrary unit; >= 0 ) <numeric>.}

\item{p6}{Repulsion radius, i.e., this parameter limits the repulsion
factor range (unit as in 'p1'; >= 0 ) <numeric>.}

\item{p7}{Central pull (arbitrary unit; >= 0 ) <numeric>.}

\item{p8}{Nest-nest edge target length, i.e., edge target between
linked containers (unit in points; >= 1 ) <numeric>.}

\item{p9}{Nest-node repulsion factor, i.e., repulsion among containers and
out-nodes (arbitrary unit; >= 0 ) <numeric>.}
}
\value{
Layout a graph in the app panel.
}
\description{
RedeR's hierarchical force-directed interactive layout.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

g <- graph.lattice(c(5, 5, 5))

rdp <- RedPort()

\donttest{
calld(rdp)
addGraph(rdp, g, layout.random(g))
relax(rdp)
}

}
\seealso{
\code{\link{addGraph}}
}
\author{
Sysbiolab.
}
