/*
 * Decompiled with CFR 0.152.
 */
package reder.application.graph;

import java.awt.Color;
import java.util.regex.Pattern;
import reder.application.RederMainFrame;
import reder.application.graph.NodeBank;

public class EdgeBank {
    protected int parceiroA;
    protected int parceiroB;
    private Color edgeColor;
    private float lineWidth;
    private String edgeType;
    private final Color corDestaque;
    protected boolean destaque;
    private double edgeWeight;
    private double normOutEdgeScale;
    private float degreeA;
    private float degreeB;
    private boolean defaultEdgeAssigment;
    private boolean isOutEdge;
    private boolean isOldEdge;
    private String edgeAssociation;
    private int arrow;
    private int units;
    private float arrowLength;
    private float arrowAngle;
    private final int edgeID;

    public EdgeBank(int parceiroA, int parceiroB, int edgeID) {
        this.edgeID = edgeID;
        this.parceiroA = parceiroA;
        this.parceiroB = parceiroB;
        this.edgeColor = new Color(147, 147, 172);
        this.lineWidth = 1.0f;
        this.edgeType = "SOLID";
        this.corDestaque = new Color(255, 204, 0);
        this.destaque = false;
        this.edgeWeight = 0.0;
        this.degreeA = 1.0f;
        this.degreeB = 1.0f;
        this.units = 1;
        this.normOutEdgeScale = 1.0;
        this.arrow = 0;
        this.defaultEdgeAssigment = true;
        this.isOutEdge = false;
        this.isOldEdge = true;
        this.edgeAssociation = "edgeNode";
        this.arrowLength = 1.0f;
        this.arrowAngle = 45.0f;
    }

    public float getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(float len) {
        this.arrowLength = len = Math.max(0.0f, len);
    }

    public void setArrowLengthScale(float len) {
        this.arrowLength *= len;
        this.arrowLength = Math.max(0.0f, this.arrowLength);
    }

    public float getArrowAngle() {
        return this.arrowAngle;
    }

    public void setArrowAngle(float angl) {
        this.arrowAngle = angl = Math.max(10.0f, Math.min(90.0f, angl));
    }

    public void setArrowAngleScale(float angl) {
        this.arrowAngle *= angl;
        this.setArrowAngle(this.arrowAngle);
    }

    public int getFinalID() {
        return this.edgeID;
    }

    public void resetNodes(int node) {
        if (this.parceiroA > node) {
            --this.parceiroA;
        }
        if (this.parceiroB > node) {
            --this.parceiroB;
        }
    }

    public void setWeight(double weight) {
        this.edgeWeight = weight;
    }

    public void setWeightScale(double weight) {
        this.edgeWeight *= weight;
    }

    public double getWeight() {
        return this.edgeWeight;
    }

    public double getMeanWeight() {
        double wmean = this.edgeWeight / (double)this.units;
        return wmean;
    }

    public void addUnit(int u) {
        this.units += u;
    }

    public int getUnit() {
        return this.units;
    }

    public void setOutEdge(boolean b) {
        this.isOutEdge = b;
    }

    public boolean isOutEdge() {
        return this.isOutEdge;
    }

    public int normOutEdgeScale() {
        if (!this.defaultEdgeAssigment) {
            NodeBank na = RederMainFrame.NodeList.get(this.parceiroA);
            NodeBank nb = RederMainFrame.NodeList.get(this.parceiroB);
            double sa = 1.0;
            double sb = 1.0;
            if (na.isContainer()) {
                sa = na.getContainerComponents().size();
            }
            if (nb.isContainer()) {
                sb = nb.getContainerComponents().size();
            }
            if (sa > 0.0 && sb > 0.0) {
                this.normOutEdgeScale = (double)this.units / (sa * sb);
                return 1;
            }
        }
        return 0;
    }

    public void setNormOutEdgeScale(double nvalue) {
        this.normOutEdgeScale = nvalue;
    }

    public double getNormOutEdge() {
        return this.normOutEdgeScale;
    }

    public void setOltEdge(boolean b) {
        this.isOldEdge = b;
    }

    public boolean isOldEdge() {
        return this.isOldEdge;
    }

    public void setDefaultEdgeAssignment(boolean b) {
        this.defaultEdgeAssigment = b;
    }

    public boolean isDefaultEdgeAssignmet() {
        return this.defaultEdgeAssigment;
    }

    public String getEdgeAssociationType() {
        if (this.isAorBContainer()) {
            if (this.defaultEdgeAssigment) {
                return "edgeTree";
            }
            return "edgeContainer";
        }
        return "edgeNode";
    }

    public boolean isAorBContainer() {
        boolean c1 = RederMainFrame.NodeList.get(this.parceiroA).isContainer();
        boolean c2 = RederMainFrame.NodeList.get(this.parceiroB).isContainer();
        return c1 || c2;
    }

    public boolean isSimpleEdge() {
        boolean c1 = !RederMainFrame.NodeList.get(this.parceiroA).isContainer();
        boolean c2 = !RederMainFrame.NodeList.get(this.parceiroB).isContainer();
        return c1 && c2;
    }

    public void updateDefaultEdgeAssigment() {
        if (!this.isAorBContainer()) {
            this.defaultEdgeAssigment = true;
        }
    }

    public void updateEdgeAssociation() {
        this.edgeAssociation = this.isAorBContainer() ? (this.defaultEdgeAssigment ? "edgeTree" : "edgeContainer") : "edgeNode";
        this.updateEdgeDegree();
    }

    public String getEdgeAssociation() {
        return this.edgeAssociation;
    }

    public void updateEdgeDegree() {
        this.degreeA = RederMainFrame.NodeList.get(this.parceiroA).getNumParceiros();
        this.degreeB = RederMainFrame.NodeList.get(this.parceiroB).getNumParceiros();
    }

    public float getEdgeDegree() {
        return Math.min(this.degreeA, this.degreeB);
    }

    public void setA(int numero) {
        this.parceiroA = numero;
    }

    public void setB(int numero) {
        this.parceiroB = numero;
    }

    public void setDestaque(boolean destaque) {
        this.destaque = destaque;
    }

    public void setDestaqueInNest(String nest) {
        boolean b3;
        NodeBank na = RederMainFrame.NodeList.get(this.parceiroA);
        NodeBank nb = RederMainFrame.NodeList.get(this.parceiroB);
        boolean b1 = na.getNestedAssignment().equals(nest);
        boolean b2 = nb.getNestedAssignment().equals(nest);
        boolean bl = b3 = !na.isContainer() && !nb.isContainer();
        if (b1 && b2 && b3) {
            this.destaque = true;
        }
    }

    public void setDestaque() {
        this.destaque = !this.destaque;
    }

    public void setEdgeColor(Color edgeColor) {
        if (edgeColor != null) {
            this.edgeColor = edgeColor;
        }
    }

    public void setLine(float width, String type) {
        this.lineWidth = width;
        this.setLineType(type);
    }

    public void setLineType(String type) {
        boolean b;
        if (type.equals("DOTTED_SHORT")) {
            type = "DOTTED";
        }
        if (b = Pattern.matches("SOLID|DASHED|LONG_DASH|DOTTED", type)) {
            this.edgeType = type;
        }
    }

    public void setLineWidth(float width) {
        if (width < 0.0f) {
            return;
        }
        float scale_a = width / this.lineWidth;
        if (width >= this.lineWidth) {
            if (width > this.arrowLength) {
                this.arrowLength *= scale_a;
            }
        } else if (width < this.arrowLength) {
            this.arrowLength *= scale_a;
        }
        this.lineWidth = width;
    }

    public void setEdgeWidthScale(float scale) {
        this.lineWidth *= scale;
        if (scale >= 1.0f) {
            if (this.lineWidth > this.arrowLength) {
                this.arrowLength *= scale;
            }
        } else if (this.lineWidth < this.arrowLength) {
            this.arrowLength *= scale;
        }
    }

    public void setArrowDirection(int direction) {
        if (direction < -4 || direction > 4) {
            return;
        }
        this.arrow = direction;
    }

    public int getArrowDirection() {
        if (this.getEdgeAssociationType().equals("edgeTree")) {
            return 0;
        }
        return this.arrow;
    }

    public int getA() {
        return this.parceiroA;
    }

    public int getB() {
        return this.parceiroB;
    }

    public Color getColor() {
        Color cor = this.destaque ? this.corDestaque : this.edgeColor;
        return cor;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public float getWidth() {
        return this.lineWidth;
    }

    public String getType() {
        return this.edgeType;
    }

    public boolean getDestaque() {
        return this.destaque;
    }
}

