% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsva_plotting_functions.R
\name{plot_gsva_pathway,ReactomeAnalysisResult-method}
\alias{plot_gsva_pathway,ReactomeAnalysisResult-method}
\title{ReactomeAnalysisResult - plot_gsva_pathway}
\usage{
\S4method{plot_gsva_pathway}{ReactomeAnalysisResult}(object, pathway_id, ...)
}
\arguments{
\item{object}{The \code{\link{ReactomeAnalysisResult}} object.}

\item{pathway_id}{The pathway's id}

\item{...}{Additional parameters for specific implementations.}
}
\value{
A ggplot2 plot object
}
\description{
Plots the expression of a specific pathway from a ssGSEA result.
}
\examples{
# load the scRNA-seq example data
library(ReactomeGSA.data)
data(jerby_b_cells)

# perform the GSVA analysis
gsva_result <- analyse_sc_clusters(jerby_b_cells, verbose = FALSE)

# create the plot
plot_obj <- plot_gsva_pathway(gsva_result, "R-HSA-389542")
}
\seealso{
Other ReactomeAnalysisResult functions: 
\code{\link{get_result}()},
\code{\link{names,ReactomeAnalysisResult-method}},
\code{\link{open_reactome}()},
\code{\link{pathways}()},
\code{\link{plot_correlations}()},
\code{\link{plot_gsva_heatmap}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_volcano}()},
\code{\link{reactome_links}()},
\code{\link{result_types}()}
}
