% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHub-class.R
\name{dataHub}
\alias{dataHub}
\alias{show,dataHub-method}
\alias{dataNames}
\alias{dataParams}
\alias{dataNotes}
\alias{dataPaths}
\alias{dataYml}
\alias{dataTags}
\alias{dataTags,dataHub-method}
\alias{dataTags<-}
\alias{dataTags<-,dataHub-method}
\alias{[,dataHub,ANY,ANY,ANY-method}
\alias{[<-,dataHub,ANY,ANY,ANY-method}
\alias{c,dataHub-method}
\alias{toList}
\title{dataHub Class}
\usage{
dataHub(BFC)

dataHub(BFC)

\S4method{show}{dataHub}(object)

dataNames(object)

dataParams(object)

dataNotes(object)

dataPaths(object)

dataYml(object)

dataTags(object)

\S4method{dataTags}{dataHub}(object)

dataTags(object, append = TRUE) <- value

\S4method{dataTags}{dataHub}(object, append = FALSE) <- value

\S4method{[}{dataHub,ANY,ANY,ANY}(x, i, j, drop)

\S4method{[}{dataHub,ANY,ANY,ANY}(x, i, j) <- value

\S4method{c}{dataHub}(x, ...)

toList(
  x,
  listNames = NULL,
  format = c("list", "json", "yaml"),
  type = NULL,
  file = character()
)
}
\arguments{
\item{BFC}{A BiocFileCache object created for data and recipes.}

\item{object}{A \code{dataHub} object.}

\item{append}{Whether to append new tag or replace all tags.}

\item{value}{A \code{dataHub} object}

\item{x}{A \code{dataHub} object.}

\item{i}{The integer index of the \code{dataHub} object, or a logical
vector same length as the \code{dataHub} object.}

\item{j}{inherited from \code{[} generic.}

\item{drop}{Inherited from \code{[} generic.}

\item{...}{More \code{dataHub} objects to combine.}

\item{listNames}{A vector of names for the output list.}

\item{format}{can be "list", "json" or "yaml". Supports partial
match. Default is list.}

\item{type}{The type of workflow input list, such as cwl.}

\item{file}{The file name to save the data list in required
format. The data extension needs to be included, e.g., ".json"
or ".yml".}
}
\value{
dataHub: a \code{dataHub} object.

dataNames: the names of datasets in \code{dataHub} object.

dataParams: the data recipe parameter values for datasets
in \code{dataHub} object.

dataNotes: the notes of datasets in \code{dataHub} object.

dataPaths: the file paths of datasets in \code{dataHub} object.

dataYml: the yaml file paths of datasets in \code{dataHub} object.

dataTags: the tags of datasets in \code{dataHub} object.

toList: A list of datasets in specific format, and a file
if \code{file} argument is specified.
}
\description{
\code{dataHub} class, constructor, and methods.
}
\examples{
outdir <- file.path(tempdir(), "SharedData")
dataUpdate(outdir, cloud = TRUE)
dd <- dataSearch(c("liftover", "GRCh38"))
dataNames(dd)
dataParams(dd)
dataNotes(dd)
dataTags(dd)
dataYml(dd)
toList(dd)
toList(dd, format = "yaml")
toList(dd, format = "json", file = tempfile())
}
