% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_importAnnotations.R
\name{importAnnotations}
\alias{importAnnotations}
\title{Imports the annotations of motifs to transcription factors}
\usage{
importAnnotations(annotFile, motifsInRanking = NULL, columnsToKeep = NULL)
}
\arguments{
\item{annotFile}{File containing the motif annotations corresponding to the
rankings. They should match in organism and version.}

\item{motifsInRanking}{Subset of motifs to keep.
e.g. 
\code{motifsInRanking=getRanking(motifRankings)$features}}

\item{columnsToKeep}{Other colums from the file to keep}
}
\value{
data.table with the annotations of the motifs to transcription factors

Columns:
 \itemize{
   \item{\bold{motif}: }{Motif ID.}
   \item{\bold{TF}: }{Transcription factor (or inferred gene).}
   \item{\bold{directAnnotation}, \bold{inferred_Orthology}, 
     \bold{inferred_MotifSimil}: }{
       Boolean values indicating whether the motif is 
       annotated to the TF in the source database ("directAnnotation"), 
       or whether it was inferred by orthology ("inferred_Orthology") 
       or motif similarity ("inferred_MotifSimil").}
   \item{\bold{Description}: }{Description of the source of the annotation.}
   \item{\bold{annotationSource}: }{Source of the annotation 
     formatted as factor (e.g. for subsetting). 
     Levels: directAnnotation, inferredBy_Orthology, 
     inferredBy_MotifSimilarity, inferredBy_MotifSimilarity_n_Orthology.}
 }
}
\description{
RcisTarget package includes the motif annotations for the rankings 
using the latest motif collection (version 10 clustered, 19895 motifs): 

\itemize{
\item{Human: }{ \code{data(motifAnnotations_hgnc)}}
\item{Mouse: }{ \code{data(motifAnnotations_mgi)}}
\item{Fly: }{ \code{data(motifAnnotations_dmel)}}

\item{Previous versions (Annotations for motif collection version 9 (24453 motifs) or 8:}{
motifAnnotations_hgnc_v9 (Human), motifAnnotations_mgi_v9 (Mouse), motifAnnotations_dmel_v9 (Fly)
motifAnnotations_hgnc_v8 (Human), motifAnnotations_mgi_v8 (Mouse), motifAnnotations_dmel_v8 (Fly)
}
}

This function (importAnnotations) allows to import annotations 
for other versions of the rankings, or to keep extra data columns.

e.g. Source of the annotations: \code{https://resources.aertslab.org/cistarget/motif2tf/}
}
\examples{
# motifAnnotations <- importAnnotations("motifs-v10nr_clust-nr.hgnc-m0.001-o0.0.tbl")

## To save (decrease from ~100MB to 1MB): 
# save(motifAnnotations, file="motifAnnotations_hngc.RData", compress='xz')

# This code would generate the equivalent to
data(motifAnnotations_hgnc)
}
\seealso{
See \emph{iRegulon} paper and documentation for \bold{details} on how the
rankings and annotations were built.
}
