% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_convertToTargetRegions.R
\name{convertToTargetRegions}
\alias{convertToTargetRegions}
\title{convertToTargetRegions}
\usage{
convertToTargetRegions(
  queryRegions,
  targetRegions,
  minOverlap = 0.4,
  overlapType = "any",
  returnCorrespondence = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{queryRegions}{List of regions to convert (normally the query region set).}

\item{targetRegions}{List of regions in the target set (normally the database).}

\item{minOverlap}{Minimum overlap to consider (in either direction, default: 0.40).}

\item{overlapType}{Parameter for \code{findOverlaps} (default: "any")}

\item{returnCorrespondence}{Returns a table containing the matches, 
or only a list of overlapping regions (default: FALSE).}

\item{verbose}{Print the number of regions selected?}
}
\value{
IDs of the regions in the "target regions" overlapping with the query regions.
}
\description{
Convert a set of input regions to the overlapping regions in the target set.
}
\examples{
\dontrun{
 ## To apply on a list of regionSets:
 regionSets_db <- lapply(regionSets, function(x) 
    convertToTargetRegions(queryRegions=x, targetRegions=dbRegionsLoc))
 }
}
\seealso{
\code{\link{getDbRegionsLoc}}.

See the package vignette for examples and more details:
\code{vignette("RcisTarget")}
}
