% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetTo-methods.R
\name{subsetTo,RadioSet-method}
\alias{subsetTo,RadioSet-method}
\title{A function to subset a RadioSet to data containing only specified radiations,
  cells and genes}
\usage{
\S4method{subsetTo}{RadioSet}(
  object,
  cells = NULL,
  radiationTypes = NULL,
  molecular.data.cells = NULL,
  keep.controls = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{RadioSet} to be subsetted}

\item{cells}{A list or vector of cell names as used in the dataset to which
the object will be subsetted. If left blank, then all cells will be left in
the dataset.}

\item{radiationTypes}{A list or vector of radiation names as used in the
dataset to which the object will be subsetted. If left blank, then all
radiationTypes will be left in the dataset.}

\item{molecular.data.cells}{A list or vector of cell names to keep in the
molecular data}

\item{keep.controls}{If the dataset has perturbation type experiments, should
the controls be kept in the dataset? Defaults to true.}

\item{...}{Other arguments passed by other function within the package}
}
\value{
A RadioSet with only the selected radiation types and cells
}
\description{
This is the prefered method of subsetting a RadioSet. This function allows
abstraction of the data to the level of biologically relevant objects:
  radiations and cells. The function will automatically go through all of the
combined data in the RadioSet and ensure only the requested radiations
and cell lines are found in any of the slots. This allows quickly picking out
all the experiments for a radiation or cell of interest, as well removes the
need to keep track of all the metadata conventions between different
datasets.
}
\examples{
clevelandRadiationTypes  <- treatmentNames(clevelandSmall)
clevelandCells <- sampleNames(clevelandSmall)
RSet <- subsetTo(clevelandSmall, radiationTypes = clevelandRadiationTypes[1],
  cells = clevelandCells[1])
RSet

}
