% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grainNetworkHelper.R
\name{marginalProb}
\alias{marginalProb}
\title{calculates the marginal probability of a set of nodes}
\usage{
marginalProb(net, states)
}
\arguments{
\item{net}{bayesian network from gRain package}

\item{states}{named list of states for each node}
}
\value{
joint-marginal probability
}
\description{
Given a bayesian network from the gRain package and a 
named list of (nodes, states), this function returns the joint-marginal
probability of each node taking a value in the specified set of states.
}
\details{
This function calculates the probability P(A,B,C) by factoring
it into conditional probabilities, i.e. P(A|B,C) * P(B|C) * P(C).
Starting at the right side, P(C) is computed and then evidence of C
being true is added to the network and P(B) is computed - effectively
giving the probability P(B|C). This process continues from right to
left until the entire product has been computed.
}
\keyword{internal}
