% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenvaluePlot.R
\name{eigenvaluePlot}
\alias{eigenvaluePlot}
\title{Plot eigenvalues of SVD of the negtaive controls.}
\usage{
eigenvaluePlot(Y, nc_index, k = 10, center = TRUE, title = "Eigenvalue Plot")
}
\arguments{
\item{Y}{A matrix of gene expressions.}

\item{nc_index}{A vector of indices for the negative controls.}

\item{k}{A numeric value giving the number of eigenvalues that should be displayed.}

\item{center}{A logical character to indicate whether centering is needed.}

\item{title}{A character string describing title.}
}
\value{
\code{eigenvaluePlot} returns a plot.
}
\description{
\code{eigenvaluePlot} plots the ratio of the ith eigenvalue 
of the SVD of the negative controls to the eigenvalue total.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)
eigenvaluePlot(Y$Y, nc_index=251:500, k=20, center=TRUE)
}
\author{
Saskia Freytag
}
