% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessQuality.R
\name{assessQuality}
\alias{assessQuality}
\title{Quality assessment for cleaning procedures.}
\usage{
assessQuality(
  est,
  true,
  index = "all",
  methods = c("all", "fnorm", "wrong.sign")
)
}
\arguments{
\item{est}{A matrix of estimated gene expression values.}

\item{true}{A matrix of true correlations.}

\item{index}{A vector of indices of genes to be included in 
the assessment; if \code{index="all"} all genes are considered.}

\item{methods}{The method used for quality assessment; 
if \code{method="fnorm"} the squared Frobenius norm is used;
if \code{method="wrong.sign"} the percentage of wrongly 
estimated signs is calculated if \code{method="all"}
both are calculated.}
}
\value{
\code{assessQuality} returns a vector of the requested quality assessments.
}
\description{
\code{assessQuality} allows to assess the quality of cleaning procedures in the context
  of correlations when the true underlying correlation structure is known.
}
\details{
The squared Frobenius norm used for \code{assessQuality} has the following structure
  \deqn{F=\frac{\|E-T\|^2}{s}}
Here, the parameter \eqn{E} and the parameter \eqn{T} denote the lower triangles of the 
estimated and true Fisher transformed correlation matrices, respectively.
The parameter \eqn{s} denotes the number of elements in \eqn{E} and \eqn{T}.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, 
Sigma.eps=0.1, 250, 100, intercept=FALSE, check.input=FALSE)  
assessQuality(Y$Y, Y$Sigma, index=1:100, methods="wrong.sign")
assessQuality(Y$Y, Y$Sigma, index=1:100, method="fnorm")
}
\author{
Saskia Freytag
}
