% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnsSRE.R
\docType{methods}
\name{tnsPlotSRE,TNS-method}
\alias{tnsPlotSRE,TNS-method}
\alias{tnsPlotSRE}
\title{Plot Subgroup Regulon Enrichment for TNS-class objects}
\usage{
\S4method{tnsPlotSRE}{TNS}(
  tns,
  subgroup = NULL,
  by = "nGroups",
  nGroupsEnriched = 1,
  nTopEnriched = 10,
  breaks = seq(-1.5, 1.5, 0.1),
  markEnriched = FALSE,
  ...
)
}
\arguments{
\item{tns}{A A \linkS4class{TNS} object.}

\item{subgroup}{a character vector. It must be the name of a column in the
survivalData featuring the grouping information as a categorical variable.}

\item{by}{one of 'nGroups' or 'groupTop'. If by = 'nGroups', the nGroupsEnriched
value will be used to select regulons. If by = 'groupTop', 'nTopEnriched' will
be used to select regulons for plotting.}

\item{nGroupsEnriched}{a single integer. It represents in how many subgroups
a regulon has to be enriched for it to appear in the rows of the heatmap.}

\item{nTopEnriched}{a single integer. If by = 'groupTop', this represents how
regulons will be shown for each group (duplicates are removed. The top regulons
are chosen by significance.}

\item{breaks}{a numerical vector of breaks for the heatmap.}

\item{markEnriched}{a single logical value. If TRUE, asterisks are added to
cells of heatmap that were found to be significant by tnsSRE.}

\item{...}{parameters passed to pheatmap::pheatmap for customization.}
}
\value{
A heatmap of the subgroup regulon enrichment results.
}
\description{
This method plots the results of the subgroup regulon enrichment analysis in
a heatmap. The rows of the heatmap represent enriched regulons, while the
columns show the subgroups. The plotted values correspond to average regulon
activity for a regulon in a subgroup. Enriched values can be marked.
}
\examples{
# load survival data
data(survival.data)
# load TNI-object
data(stni, package = "RTN")

# create TNS object
stns <- tni2tnsPreprocess(stni, survivalData = survival.data,
                          keycovar = c('Grade','Age'), time = 1, event = 2)
stns <- tnsGSEA2(stns)

# run subgroup regulon enrichment analysis
stns <- tnsSRE(stns, "ER+")
tnsPlotSRE(stns)

}
