% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tnsPlotGSEA2,TNS-method}
\alias{tnsPlotGSEA2,TNS-method}
\alias{tnsPlotGSEA2}
\title{Plot 2-tailed GSEA for a sample from a TNS}
\usage{
\S4method{tnsPlotGSEA2}{TNS}(
  tns,
  aSample,
  regs = NULL,
  refsamp = NULL,
  checklog = FALSE,
  ntop = NULL,
  pValueCutoff = 0.05,
  pAdjustMethod = "BH",
  verbose = TRUE,
  plotpdf = FALSE,
  ...
)
}
\arguments{
\item{tns}{A \linkS4class{TNS} object}

\item{aSample}{A string specifying a given sample number present in the 
'survivalData' table.}

\item{regs}{An optional string vector specifying regulons to make the plot.}

\item{refsamp}{A character vector.}

\item{checklog}{A logical value. If TRUE, expression values are transformed 
into log space.}

\item{ntop}{An optional integer value. The number of regulons for which the 
GSEA2 will be plotted.}

\item{pValueCutoff}{A numeric value in [0,1]. The p-value cutoff for the 
analysis.}

\item{pAdjustMethod}{A character. Specifies the adjustment method for the 
pvalue.
See \code{\link{p.adjust}}}

\item{verbose}{A logical value specifying to display detailed messages 
(when verbose=TRUE) or not (when verbose=FALSE).}

\item{plotpdf}{A single logical value.}

\item{...}{parameters which will be passed to \code{\link{tna.plot.gsea2}},
such as ylimPanels, heightPanels, width, height, ylabPanels, xlab...}
}
\value{
A plot containing the 2-tailed GSEA analysis for a phenotype.
}
\description{
Makes a 2-tailed GSEA plot for a certain phenotype (sample)
present in a TNS. A wrapper of \code{\link{tna.plot.gsea2}}
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

stns <- tni2tnsPreprocess(stni, survivalData = survival.data, 
        keycovar = c('Grade','Age'), time = 1, event = 2)
stns <- tnsGSEA2(stns, verbose=FALSE)
tnsPlotGSEA2(stns, 'MB-5115', regs = 'FOXM1', plotpdf = FALSE)

}
\seealso{
\code{\link{tna.plot.gsea2}} for all plot parameters
}
