% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tnsInteraction,TNS-method}
\alias{tnsInteraction,TNS-method}
\alias{tnsInteraction}
\title{Survival analysis for dual regulons}
\usage{
\S4method{tnsInteraction}{TNS}(tns, ..., verbose = TRUE)
}
\arguments{
\item{tns}{A \linkS4class{TNS} object, which must have passed GSEA2 analysis.}

\item{...}{Parameters passed to \code{\link{tnsKmInteraction}} and 
\code{\link{tnsCoxInteraction}} functions.}

\item{verbose}{A logical value specifying to display detailed messages 
(when verbose=TRUE) or not (when verbose=FALSE).}
}
\value{
A \linkS4class{TNS} object evaluated by the 'tnsKmInteraction' and 
'tnsCoxInteraction' functions.
}
\description{
A generic call to 'tnsCoxInteraction' and 'tnsKmInteraction' functions.
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

stns <- tni2tnsPreprocess(stni, survivalData = survival.data, 
keycovar = c('Grade','Age'), time = 1, event = 2)
stns <- tnsGSEA2(stns)

# survival analysis for dual regulons
# stns <- tnsInteraction(stns, stepFilter = FALSE)

}
