\name{tni.annotate.samples}
\alias{tni.annotate.samples}

\title{
Annotate samples with external gene set collections.
}

\description{
This function calculates an enrichment score between gene sets and samples.
}

\usage{
tni.annotate.samples(object, geneSetList, minSetSize = 15, 
    exponent = 1, samples=NULL, verbose = TRUE)
}

\arguments{

\item{object}{
a preprocessed object of class 'TNI' \code{\link[RTN:TNI-class]{TNI-class}}.
}
\item{geneSetList}{
a list with gene sets.
}
\item{minSetSize}{
a single integer or numeric value specifying the minimum number of 
elements in a gene set that must map to elements of the gene universe. 
Gene sets with fewer than this number are removed from the analysis.
}
\item{exponent}{
a single integer or numeric value used in weighting phenotypes in GSEA
(this parameter only affects the GSEA statistics).
}
\item{samples}{
an optional string vector listing the sample names for which 
will be computed the GSEA statistics.
}
\item{verbose}{
a single logical value specifying to display detailed messages (when 
verbose=TRUE) or not (when verbose=FALSE).
}
}

\details{
Using the samples available in the provided TNI object, the 'tni.annotate.samples' calculates the enrichment of each sample for each gene set. First, a gene-wise differential expression (DEG) signature is generated by comparing the expression of a given sample with the avarage expression of all samples. The DEG signature is regarded as a the sample phenotype, representing the relative expression of the sample's genes in the cohort. Then a single-sample Gene Set Enrichment Analysis (ssGSEA) is used to calculate the enrichment score (ES) of the sample for a given gene set.
}

\value{
A numeric matrix with association statistics between gene sets vs. samples.
}

\author{Mauro Castro}

\seealso{
\code{\link[RTN:TNI-class]{TNI-class}}
}

\examples{

data(tniData)

\dontrun{

#generate a TNI object
rtni <- tni.constructor(expData=tniData$expData, 
        regulatoryElements=c("PTTG1","E2F2","FOXM1","E2F3","RUNX2"), 
        rowAnnotation=tniData$rowAnnotation)
rtni <- tni.permutation(rtni)
rtni <- tni.bootstrap(rtni)
rtni <- tni.dpi.filter(rtni)

#load a gene set collection
#here, we build three random gene sets for demonstration
geneset1 <- sample(tniData$rowAnnotation$SYMBOL,50)
geneset2 <- sample(tniData$rowAnnotation$SYMBOL,50)
geneset3 <- sample(tniData$rowAnnotation$SYMBOL,50)
geneSetList <- list(geneset1=geneset1,
                    geneset2=geneset2,
                    geneset3=geneset3)

#compute single-sample GSEA
#note: regulons are not required for this function, 
#as it will assess the samples in the TNI object
ES <- tni.annotate.samples(rtni, geneSetList)

}
}

\keyword{annotate}
