% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalTCGA.R
\name{survivalTCGA}
\alias{survivalTCGA}
\title{Extract Survival Information from Datasets Included in RTCGA.clinical and RTCGA.clinical.20160128 Packages}
\usage{
survivalTCGA(
  ...,
  extract.cols = NULL,
  extract.names = FALSE,
  barcode.name = "patient.bcr_patient_barcode",
  event.name = "patient.vital_status",
  days.to.followup.name = "patient.days_to_last_followup",
  days.to.death.name = "patient.days_to_death"
)
}
\arguments{
\item{...}{A data.frame or data.frames from TCGA study containing clinical informations. See \link[RTCGA.clinical]{clinical}.}

\item{extract.cols}{A character specifing the names of extra columns to be extracted with survival information.}

\item{extract.names}{Logical, whether to extract names of passed data.frames in \code{...}.}

\item{barcode.name}{A character with the name of \code{bcr_patient_barcode} which differs between TCGA releases. 
By default is the name from the newest release date \code{tail(checkTCGA('Dates'),1)}.}

\item{event.name}{A character with the name of \code{patient.vital_status} which differs between TCGA releases. 
By default is the name from the newest release date \code{tail(checkTCGA('Dates'),1)}.}

\item{days.to.followup.name}{A character with the name of \code{patient.days_to_last_followup} which differs between TCGA releases. 
By default is the name from the newest release date \code{tail(checkTCGA('Dates'),1)}.}

\item{days.to.death.name}{A character with the name of \code{patient.days_to_death} which differs between TCGA releases. 
By default is the name from the newest release date \code{tail(checkTCGA('Dates'),1)}.}
}
\value{
A data.frame containing information about times and censoring for specific \code{bcr_patient_barcode}.
The name passed in \code{barcode.name} is changed to \code{bcr_patient_barcode}.
}
\description{
Extracts survival information from clicnial datasets from TCGA project.
}
\note{
Input data.frames should contain columns \code{patient.bcr_patient_barcode}, 
\code{patient.vital_status}, \code{patient.days_to_last_followup}, \code{patient.days_to_death} or theyir previous
equivalents. 
It is recommended to use datasets from \link[RTCGA.clinical]{clinical}.
}
\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{

## Extracting Survival Data
library(RTCGA.clinical)
survivalTCGA(BRCA.clinical, OV.clinical, extract.cols = "admin.disease_code") -> BRCAOV.survInfo

## Kaplan-Meier Survival Curves
kmTCGA(BRCAOV.survInfo, explanatory.names = "admin.disease_code",  pval = TRUE)

kmTCGA(BRCAOV.survInfo, explanatory.names = "admin.disease_code", main = "",
       xlim = c(0,4000))
       
# first munge data, then extract survival info
library(dplyr)
BRCA.clinical \%>\%
    filter(patient.drugs.drug.therapy_types.therapy_type \%in\%
               c("chemotherapy", "hormone therapy")) \%>\%
    rename(therapy = patient.drugs.drug.therapy_types.therapy_type) \%>\%
    survivalTCGA(extract.cols = c("therapy"))  -> BRCA.survInfo.chemo
                 
# first extract survival info, then munge data                  
    survivalTCGA(BRCA.clinical, 
                 extract.cols = c("patient.drugs.drug.therapy_types.therapy_type"))  \%>\%
    filter(patient.drugs.drug.therapy_types.therapy_type \%in\%
               c("chemotherapy", "hormone therapy")) \%>\%
    rename(therapy = patient.drugs.drug.therapy_types.therapy_type) -> BRCA.survInfo.chemo


kmTCGA(BRCA.survInfo.chemo, explanatory.names = "therapy",
       xlim = c(0, 3000), conf.int = FALSE)
}
\seealso{
\pkg{RTCGA} website \href{http://rtcga.github.io/RTCGA/articles/Visualizations.html}{http://rtcga.github.io/RTCGA/articles/Visualizations.html}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{boxplotTCGA}()},
\code{\link{checkTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{datasetsTCGA}},
\code{\link{downloadTCGA}()},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{infoTCGA}()},
\code{\link{installTCGA}()},
\code{\link{kmTCGA}()},
\code{\link{mutationsTCGA}()},
\code{\link{pcaTCGA}()},
\code{\link{readTCGA}()},
\code{\link{theme_RTCGA}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}

Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{RTCGA}
