% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplotTCGA.R
\name{boxplotTCGA}
\alias{boxplotTCGA}
\title{Create Boxplots for TCGA Datasets}
\usage{
boxplotTCGA(
  data,
  x,
  y,
  fill = x,
  coord.flip = TRUE,
  facet.names = NULL,
  ylab = y,
  xlab = x,
  legend.title = xlab,
  legend = "top",
  ...,
  ggtheme = theme_RTCGA()
)
}
\arguments{
\item{data}{A data.frame from TCGA study containing variables to be plotted.}

\item{x}{A character name of variable containing groups.}

\item{y}{A character name of continous variable to be plotted.}

\item{fill}{A character names of fill variable. By default, the same as \code{x}.}

\item{coord.flip}{Whether to flip coordinates.}

\item{facet.names}{A character of length maximum 2 containing names of variables to produce facets. See examples.}

\item{ylab}{The name of y label. Remember about \code{coord.flip}.}

\item{xlab}{The name of x label. Remember about \code{coord.flip}.}

\item{legend.title}{A character with legend's title.}

\item{legend}{A character specifying legend position. Allowed values are one of
c("top", "bottom", "left", "right", "none"). Default is "top" side position.
to remove the legend use legend = "none".}

\item{...}{Further arguments passed to \link{geom_boxplot}.}

\item{ggtheme}{a \code{ggtheme} to be used (set to \code{NULL}, if using \pkg{ggthemr} package)}
}
\description{
Function creates boxplots (\link{geom_boxplot}) for TCGA Datasets.
}
\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{
library(RTCGA)
library(RTCGA.rnaseq)
# perfrom plot
library(dplyr)
expressionsTCGA(ACC.rnaseq, BLCA.rnaseq, BRCA.rnaseq, OV.rnaseq,
  extract.cols = "MET|4233") \%>\%
  rename(cohort = dataset,
  MET = `MET|4233`) \%>\%  
  #cancer samples
  filter(substr(bcr_patient_barcode, 14, 15) == "01") -> ACC_BLCA_BRCA_OV.rnaseq
  

boxplotTCGA(ACC_BLCA_BRCA_OV.rnaseq, "cohort", "MET")
boxplotTCGA(ACC_BLCA_BRCA_OV.rnaseq, "cohort", "log1p(MET)")
boxplotTCGA(ACC_BLCA_BRCA_OV.rnaseq, "reorder(cohort,log1p(MET), median)", "log1p(MET)")
boxplotTCGA(ACC_BLCA_BRCA_OV.rnaseq, "reorder(cohort,log1p(MET), max)", "log1p(MET)")
boxplotTCGA(ACC_BLCA_BRCA_OV.rnaseq, "reorder(cohort,log1p(MET), median)", "log1p(MET)",
            xlab = "Cohort Type", ylab = "Logarithm of MET")
boxplotTCGA(ACC_BLCA_BRCA_OV.rnaseq, "reorder(cohort,log1p(MET), median)", "log1p(MET)", 
            xlab = "Cohort Type", ylab = "Logarithm of MET", legend.title = "Cohorts")
boxplotTCGA(ACC_BLCA_BRCA_OV.rnaseq, "reorder(cohort,log1p(MET), median)", "log1p(MET)", 
            xlab = "Cohort Type", ylab = "Logarithm of MET", 
            legend.title = "Cohorts", legend = "bottom")

## facet example
library(RTCGA.mutations)
library(dplyr)
mutationsTCGA(BRCA.mutations, OV.mutations, ACC.mutations, BLCA.mutations) \%>\% 
  filter(Hugo_Symbol == 'TP53') \%>\%
  filter(substr(bcr_patient_barcode, 14, 15) == "01") \%>\% # cancer tissue
  mutate(bcr_patient_barcode = substr(bcr_patient_barcode, 1, 12)) -> 
  ACC_BLCA_BRCA_OV.mutations

mutationsTCGA(BRCA.mutations, OV.mutations, ACC.mutations, BLCA.mutations) -> 
  ACC_BLCA_BRCA_OV.mutations_all

ACC_BLCA_BRCA_OV.rnaseq \%>\%
  mutate(bcr_patient_barcode = substr(bcr_patient_barcode, 1, 15)) \%>\%
  filter(bcr_patient_barcode \%in\% 
  substr(ACC_BLCA_BRCA_OV.mutations_all$bcr_patient_barcode, 1, 15)) \%>\%
  # took patients for which we had any mutation information
  # so avoided patients without any information about mutations
  mutate(bcr_patient_barcode = substr(bcr_patient_barcode, 1, 12)) \%>\%
  # strin_length(ACC_BLCA_BRCA_OV.mutations$bcr_patient_barcode) == 12
  left_join(ACC_BLCA_BRCA_OV.mutations,
  by = "bcr_patient_barcode") \%>\% #joined only with tumor patients
  mutate(TP53 = ifelse(!is.na(Variant_Classification), "Mut", "WILD")) \%>\%
  select(cohort, MET, TP53) -> ACC_BLCA_BRCA_OV.rnaseq_TP53mutations

boxplotTCGA(ACC_BLCA_BRCA_OV.rnaseq_TP53mutations, "reorder(cohort,log1p(MET), median)",
            "log1p(MET)", xlab = "Cohort Type", ylab = "Logarithm of MET", 
            legend.title = "Cohorts", legend = "bottom", facet.names = c("TP53"))

boxplotTCGA(ACC_BLCA_BRCA_OV.rnaseq_TP53mutations, "reorder(cohort,log1p(MET), median)",
            "log1p(MET)", xlab = "Cohort Type", ylab = "Logarithm of MET",
            legend.title = "Cohorts", legend = "bottom", fill = c("TP53"))


}
\seealso{
\pkg{RTCGA} website \href{http://rtcga.github.io/RTCGA/articles/Visualizations.html}{http://rtcga.github.io/RTCGA/articles/Visualizations.html}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{checkTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{datasetsTCGA}},
\code{\link{downloadTCGA}()},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{infoTCGA}()},
\code{\link{installTCGA}()},
\code{\link{kmTCGA}()},
\code{\link{mutationsTCGA}()},
\code{\link{pcaTCGA}()},
\code{\link{readTCGA}()},
\code{\link{survivalTCGA}()},
\code{\link{theme_RTCGA}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{RTCGA}
