% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocExtract.R
\name{biocExtract}
\alias{biocExtract}
\title{Extract and convert data from a \code{FirehoseData} object to a
\code{Bioconductor} object}
\usage{
biocExtract(
  object,
  type = c("clinical", "RNASeqGene", "RNASeq2Gene", "miRNASeqGene", "RNASeq2GeneNorm",
    "CNASNP", "CNVSNP", "CNASeq", "CNACGH", "Methylation", "Mutation", "mRNAArray",
    "miRNAArray", "RPPAArray", "GISTIC", "GISTICA", "GISTICT", "GISTICP"),
  ...
)
}
\arguments{
\item{object}{A \code{FirehoseData} object from which to extract data.}

\item{type}{The type of data to extract from the "FirehoseData" object,
see type section.}

\item{...}{Additional arguments passed to lower level functions that
convert tabular data into Bioconductor object such as
\code{.makeRangedSummarizedExperimentFromDataFrame} or
\code{.makeRaggedExperimentFromDataFrame}}
}
\value{
Either
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment} or
\link[RaggedExperiment:RaggedExperiment-class]{RaggedExperiment}.
}
\description{
This function processes data from a
\link[=FirehoseData-class]{FirehoseData} object. Raw data is
converted to a conventional Bioconductor object. The function returns either
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}
or \link[RaggedExperiment:RaggedExperiment-class]{RaggedExperiment}. In cases
where there are multiple platforms in a data type, an attempt to consolidate
datasets will be made based on matching dimension names. For ranged data,
this functionality is provided with more control as part of the
\code{RaggedExperiment} features. See the
\link[RaggedExperiment:RaggedExperiment-class]{RaggedExperiment-class} for
more details.
}
\details{
A typical additional argument for this function passed down to
lower level functions is the \code{names.field} which indicates the row names
in the data. By default, it is the "Hugo_Symbol" column in the internal
code that converts \code{data.frame}s to \code{SummarizedExperiment} representations
(via the \code{.makeSummarizedExperimentFromDataFrame} internal function).
}
\section{type}{

Choices include the following:
\itemize{
\item clinical: Get the clinical data slot
\item RNASeqGene: RNASeqGene, RNASeq v1
\item RNASeqGene: RNASeq2Gene, RNASeq v2
\item RNASeq2GeneNorm: RNASeq v2 Normalized
\item miRNASeqGene: micro RNA SeqGene
\item CNASNP: Copy Number Alteration
\item CNVSNP: Copy Number Variation
\item CNASeq: Copy Number Alteration
\item CNACGH: Copy Number Alteration
\item Methylation: Methylation
\item mRNAArray: Messenger RNA
\item miRNAArray: micro RNA
\item RPPAArray: Reverse Phase Protein Array
\item Mutation: Mutations
\item GISTICA: GISTIC v2 ('AllByGene' only)
\item GISTICT: GISTIC v2 ('ThresholdedByGene' only)
\item GISTICP: GISTIC v2 ('Peaks' only)
\item GISTIC: GISTIC v2 scores, probabilities, and peaks
}
}

\examples{

data(accmini)
biocExtract(accmini, "RNASeq2Gene")
biocExtract(accmini, "miRNASeqGene")
biocExtract(accmini, "RNASeq2GeneNorm")
biocExtract(accmini, "CNASNP")
biocExtract(accmini, "CNVSNP")
biocExtract(accmini, "Methylation")
biocExtract(accmini, "Mutation")
biocExtract(accmini, "RPPAArray")
biocExtract(accmini, "GISTIC")

}
\author{
Marcel Ramos \email{marcel.ramos@sph.cuny.edu}
}
