% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTCGAToolbox-Class.R, R/selectType.R
\docType{class}
\name{FirehoseData-class}
\alias{FirehoseData-class}
\alias{show,FirehoseData-method}
\alias{getData,FirehoseData-method}
\alias{getData,FirehoseGISTIC-method}
\alias{getData,ANY-method}
\alias{updateObject,FirehoseData-method}
\alias{selectType,FirehoseData-method}
\title{An S4 class to store main data object from clinent function.}
\usage{
\S4method{show}{FirehoseData}(object)

\S4method{getData}{FirehoseData}(object, type, platform)

\S4method{getData}{FirehoseGISTIC}(object, type, platform)

\S4method{getData}{ANY}(object, type, platform)

\S4method{updateObject}{FirehoseData}(object, ..., verbose = FALSE)

\S4method{selectType}{FirehoseData}(object, dataType)
}
\arguments{
\item{object}{A FirehoseData object}

\item{type}{A data type to be extracted}

\item{platform}{An index for data types that may come from multiple
platforms (such as mRNAArray), for GISTIC data, one of the options:
'AllByGene', 'ThresholdedByGene', or 'Peaks'}

\item{...}{additional arguments for updateObject}

\item{verbose}{logical (default FALSE) whether to print extra messages}

\item{dataType}{An available data type, see object show method}
}
\description{
An S4 class to store main data object from clinent function.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show(FirehoseData)}: show method

\item \code{getData(FirehoseData)}: Get a matrix or data.frame from \code{FirehoseData}

\item \code{getData(FirehoseGISTIC)}: Get GISTIC data from \code{FirehoseData}

\item \code{getData(ANY)}: Default method for getting data from
\code{FirehoseData}

\item \code{updateObject(FirehoseData)}: Update an old RTCGAToolbox FirehoseData object to
the most recent API

\item \code{selectType(FirehoseData)}: Extract data type

}}
\section{Slots}{

\describe{
\item{\code{Dataset}}{A cohort name}

\item{\code{runDate}}{Standard data run date from \link{getFirehoseRunningDates}}

\item{\code{gistic2Date}}{Analyze running date from \link{getFirehoseAnalyzeDates}}

\item{\code{clinical}}{clinical data frame}

\item{\code{RNASeqGene}}{Gene level expression data matrix from RNAseq}

\item{\code{RNASeq2Gene}}{Gene level expression data matrix from RNAseqV2}

\item{\code{RNASeq2GeneNorm}}{Gene level expression data matrix from RNAseqV2 (RSEM)}

\item{\code{miRNASeqGene}}{miRNA expression data from matrix smallRNAseq}

\item{\code{CNASNP}}{A data frame to store somatic copy number alterations from SNP
array platform}

\item{\code{CNVSNP}}{A data frame to store germline copy number variants from SNP
array platform}

\item{\code{CNASeq}}{A data frame to store somatic copy number alterations from
sequencing platform}

\item{\code{CNACGH}}{A list that stores \code{FirehoseCGHArray} object for somatic
copy number alterations from CGH platform}

\item{\code{Methylation}}{A list that stores \code{FirehoseMethylationArray} object
for methylation data}

\item{\code{mRNAArray}}{A list that stores \code{FirehosemRNAArray} object for gene
expression data from microarray}

\item{\code{miRNAArray}}{A list that stores \code{FirehosemRNAArray} object for miRNA
expression data from microarray}

\item{\code{RPPAArray}}{A list that stores \code{FirehosemRNAArray} object for RPPA
data}

\item{\code{Mutation}}{A data frame for mutation infromation from sequencing data}

\item{\code{GISTIC}}{A \code{FirehoseGISTIC} object to store processed copy number
data}

\item{\code{BarcodeUUID}}{A data frame that stores the Barcodes, UUIDs and Short
sample identifiers}
}}

