% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcpAUC.R
\name{mcpAUC}
\alias{mcpAUC}
\title{Clasification of area under ROC curve following McClish method}
\usage{
mcpAUC(
  dataset,
  low.value = NULL,
  up.value = NULL,
  plot = FALSE,
  selection = NULL,
  variable = NULL
)
}
\arguments{
\item{dataset}{Dataframe of the complete information of the samples}

\item{low.value}{lower false positive rate value that the function
will use to calculate the pAUC}

\item{up.value}{upper false positive rate value that the function
will use to calculate the pAUC}

\item{plot}{ROC plot}

\item{selection}{vector that will only be used if the parameter
"dataset" is a RangedSummarizedExperiment object.
This parameter is used to select the variables that will be analysed}

\item{variable}{in case that dataset is a  SummarizedExperiment,
indicate the Gold Standard}
}
\value{
RangedSummarizedExperiment object with the pAUC and the
mcpAUC scores,and the TPR and FPR values for each ROC curve generated
}
\description{
Calculate the area under the ROC curve following
McClish methodologic from a dataset and a sample from that dataset.
}
\examples{
library(fission)
data("fission")
resultsMC <- mcpAUC(fission, low.value = 0, up.value = 0.25, plot = TRUE,
selection = c("SPNCRNA.1080","SPAC186.08c"), variable="strain")
}
